/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.session;

import java.util.Map;
import java.util.Properties;
import org.kie.KieBase;
import org.kie.KieBaseConfiguration;
import org.kie.KieServices;
import org.kie.KnowledgeBase;
import org.kie.KnowledgeBaseFactory;
import org.kie.builder.KnowledgeBuilder;
import org.kie.builder.KnowledgeBuilderConfiguration;
import org.kie.builder.KnowledgeBuilderError;
import org.kie.builder.KnowledgeBuilderErrors;
import org.kie.builder.KnowledgeBuilderFactory;
import org.kie.event.KieRuntimeEventManager;
import org.kie.persistence.jpa.KieStoreServices;
import org.kie.runtime.Environment;
import org.kie.runtime.KieRuntime;
import org.kie.runtime.KieSession;
import org.kie.runtime.KieSessionConfiguration;
import org.kie.runtime.StatelessKieSession;
import org.switchyard.ServiceDomain;
import org.switchyard.component.common.knowledge.config.model.KnowledgeComponentImplementationModel;
import org.switchyard.component.common.knowledge.session.KnowledgeDisposal;
import org.switchyard.component.common.knowledge.session.KnowledgeSession;
import org.switchyard.component.common.knowledge.session.KnowledgeSessionFactory;
import org.switchyard.component.common.knowledge.util.Channels;
import org.switchyard.component.common.knowledge.util.Configurations;
import org.switchyard.component.common.knowledge.util.Environments;
import org.switchyard.component.common.knowledge.util.Listeners;
import org.switchyard.component.common.knowledge.util.Loggers;
import org.switchyard.component.common.knowledge.util.Resources;
import org.switchyard.exception.SwitchYardException;

class KnowledgeBaseSessionFactory
extends KnowledgeSessionFactory {
    private static final String LINE_SEPARATOR;
    private final KieBase _base = this.newBase();
    private final KieSessionConfiguration _sessionConfiguration = Configurations.getSessionConfiguration(this.getModel(), this.getPropertyOverrides());

    KnowledgeBaseSessionFactory(KnowledgeComponentImplementationModel model, ClassLoader loader, ServiceDomain domain, Properties propertyOverrides) {
        super(model, loader, domain, propertyOverrides);
    }

    @Override
    public KnowledgeSession newStatelessSession() {
        StatelessKieSession stateless = this._base.newStatelessKieSession(this._sessionConfiguration);
        KnowledgeDisposal loggersDisposal = Loggers.registerLoggersForDisposal(this.getModel(), this.getLoader(), (KieRuntimeEventManager)stateless);
        Listeners.registerListeners(this.getModel(), this.getLoader(), (KieRuntimeEventManager)stateless);
        return new KnowledgeSession(stateless, loggersDisposal);
    }

    @Override
    public KnowledgeSession newStatefulSession(Map<String, Object> environmentOverrides) {
        Environment env = Environments.getEnvironment(environmentOverrides);
        KieSession stateful = this._base.newKieSession(this._sessionConfiguration, env);
        KnowledgeDisposal loggersDisposal = Loggers.registerLoggersForDisposal(this.getModel(), this.getLoader(), (KieRuntimeEventManager)stateful);
        Listeners.registerListeners(this.getModel(), this.getLoader(), (KieRuntimeEventManager)stateful);
        Channels.registerChannels(this.getModel(), this.getLoader(), (KieRuntime)stateful, this.getDomain());
        return new KnowledgeSession(stateful, false, loggersDisposal);
    }

    @Override
    public KnowledgeSession getPersistentSession(Map<String, Object> environmentOverrides, Integer sessionId) {
        KieStoreServices kieStoreServices = KieServices.Factory.get().getStoreServices();
        Environment env = Environments.getEnvironment(environmentOverrides);
        KieSession stateful = null;
        if (sessionId != null) {
            stateful = kieStoreServices.loadKieSession(sessionId.intValue(), this._base, this._sessionConfiguration, env);
        }
        if (stateful == null) {
            stateful = kieStoreServices.newKieSession(this._base, this._sessionConfiguration, env);
        }
        KnowledgeDisposal loggersDisposal = Loggers.registerLoggersForDisposal(this.getModel(), this.getLoader(), stateful);
        Listeners.registerListeners(this.getModel(), this.getLoader(), (KieRuntimeEventManager)stateful);
        Channels.registerChannels(this.getModel(), this.getLoader(), (KieRuntime)stateful, this.getDomain());
        return new KnowledgeSession(stateful, true, loggersDisposal);
    }

    private KieBase newBase() {
        KieBaseConfiguration baseConfiguration = Configurations.getBaseConfiguration(this.getModel(), this.getPropertyOverrides(), this.getLoader());
        KnowledgeBase base = KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)baseConfiguration);
        KnowledgeBuilderConfiguration builderConfiguration = Configurations.getBuilderConfiguration(this.getModel(), this.getPropertyOverrides(), this.getLoader());
        KnowledgeBuilder builder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBase)base, (KnowledgeBuilderConfiguration)builderConfiguration);
        Resources.addResources(this.getModel(), this.getLoader(), builder);
        try {
            return builder.newKnowledgeBase();
        }
        catch (Throwable t) {
            StringBuilder sb = new StringBuilder("Problem creating knowledge base");
            String tm = t.getMessage();
            if (tm != null) {
                sb.append(": ");
                sb.append(tm.trim());
            }
            KnowledgeBuilderErrors errors = builder.getErrors();
            for (KnowledgeBuilderError error : errors) {
                sb.append(LINE_SEPARATOR);
                sb.append(error.toString().trim());
            }
            throw new SwitchYardException(sb.toString(), t);
        }
    }

    static {
        String lineSeparator;
        try {
            lineSeparator = System.getProperty("line.separator", "\n");
        }
        catch (Throwable t) {
            lineSeparator = "\n";
        }
        LINE_SEPARATOR = lineSeparator;
    }
}

