/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.composer;

import org.switchyard.Context;
import org.switchyard.Exchange;
import org.switchyard.Message;
import org.switchyard.Scope;
import org.switchyard.composer.BaseMessageComposer;

public class CamelMessageComposer
extends BaseMessageComposer<org.apache.camel.Message> {
    public Message compose(org.apache.camel.Message source, Exchange exchange, boolean create) throws Exception {
        this.getContextMapper().mapFrom((Object)source, exchange.getContext());
        Message message = create ? exchange.createMessage() : exchange.getMessage();
        Class<?> contentType = CamelMessageComposer.getContentType(exchange);
        if (contentType != null) {
            message.setContent(source.getBody(contentType));
        } else {
            message.setContent(source.getBody());
        }
        return message;
    }

    public org.apache.camel.Message decompose(Exchange exchange, org.apache.camel.Message target) throws Exception {
        this.getContextMapper().mapTo(exchange.getContext(), (Object)target);
        Class<?> contentType = CamelMessageComposer.getContentType(exchange);
        if (contentType != null) {
            target.setBody(exchange.getMessage().getContent(contentType));
        } else {
            target.setBody(exchange.getMessage().getContent());
        }
        return target;
    }

    public static final Class<?> getContentType(Exchange exchange) {
        ContentTypeProvider contentTypeProvider = CamelMessageComposer.getContentTypeProvider(exchange);
        return contentTypeProvider != null ? contentTypeProvider.getContentType() : null;
    }

    public static final ContentTypeProvider getContentTypeProvider(Exchange exchange) {
        return (ContentTypeProvider)exchange.getContext().getPropertyValue(ContentTypeProvider.KEY);
    }

    public static final void setContentTypeProvider(Exchange exchange, ContentTypeProvider contentTypeProvider) {
        Context context = exchange.getContext();
        if (contentTypeProvider != null) {
            context.setProperty(ContentTypeProvider.KEY, (Object)contentTypeProvider, Scope.EXCHANGE);
        } else {
            context.setProperty(ContentTypeProvider.KEY, null, Scope.EXCHANGE);
        }
    }

    public static interface ContentTypeProvider {
        public static final String KEY = ContentTypeProvider.class.getName();

        public Class<?> getContentType();
    }
}

