/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging;

import org.slf4j.bridge.SLF4JBridgeHandler;
import org.springframework.boot.logging.AbstractLoggingSystem;
import org.springframework.util.ClassUtils;

public abstract class Slf4JLoggingSystem
extends AbstractLoggingSystem {
    private static final String BRIDGE_HANDLER = "org.slf4j.bridge.SLF4JBridgeHandler";

    public Slf4JLoggingSystem(ClassLoader classLoader) {
        super(classLoader);
    }

    @Override
    public void beforeInitialize() {
        super.beforeInitialize();
        this.configureJdkLoggingBridgeHandler();
    }

    @Override
    public void cleanUp() {
        this.removeJdkLoggingBridgeHandler();
    }

    private void configureJdkLoggingBridgeHandler() {
        try {
            if (this.isBridgeHandlerAvailable()) {
                this.removeJdkLoggingBridgeHandler();
                SLF4JBridgeHandler.install();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected final boolean isBridgeHandlerAvailable() {
        return ClassUtils.isPresent((String)BRIDGE_HANDLER, (ClassLoader)this.getClassLoader());
    }

    private void removeJdkLoggingBridgeHandler() {
        try {
            if (this.isBridgeHandlerAvailable()) {
                try {
                    SLF4JBridgeHandler.removeHandlersForRootLogger();
                }
                catch (NoSuchMethodError ex) {
                    SLF4JBridgeHandler.uninstall();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

