/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context;

import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.web.SpringBootMockServletContext;
import org.springframework.boot.test.util.EnvironmentTestUtils;
import org.springframework.boot.web.support.ServletContextApplicationContextInitializer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.SpringVersion;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.core.env.PropertySourcesPropertyResolver;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.support.AbstractContextLoader;
import org.springframework.test.context.support.AnnotationConfigContextLoaderUtils;
import org.springframework.test.context.support.TestPropertySourceUtils;
import org.springframework.test.context.web.WebMergedContextConfiguration;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.support.GenericWebApplicationContext;

public class SpringBootContextLoader
extends AbstractContextLoader {
    private static final Set<String> INTEGRATION_TEST_ANNOTATIONS;

    public ApplicationContext loadContext(MergedContextConfiguration config) throws Exception {
        SpringApplication application = this.getSpringApplication();
        application.setMainApplicationClass(config.getTestClass());
        application.setSources(this.getSources(config));
        StandardEnvironment environment = new StandardEnvironment();
        if (!ObjectUtils.isEmpty((Object[])config.getActiveProfiles())) {
            this.setActiveProfiles((ConfigurableEnvironment)environment, config.getActiveProfiles());
        }
        TestPropertySourceUtils.addPropertiesFilesToEnvironment((ConfigurableEnvironment)environment, (ResourceLoader)(application.getResourceLoader() == null ? new DefaultResourceLoader(((Object)((Object)this)).getClass().getClassLoader()) : application.getResourceLoader()), (String[])config.getPropertySourceLocations());
        TestPropertySourceUtils.addInlinedPropertiesToEnvironment((ConfigurableEnvironment)environment, (String[])this.getInlinedProperties(config));
        application.setEnvironment((ConfigurableEnvironment)environment);
        List<ApplicationContextInitializer<?>> initializers = this.getInitializers(config, application);
        if (config instanceof WebMergedContextConfiguration) {
            application.setWebEnvironment(true);
            if (!this.isEmbeddedWebEnvironment(config)) {
                new WebConfigurer().configure(config, application, initializers);
            }
        } else {
            application.setWebEnvironment(false);
        }
        application.setInitializers(initializers);
        ConfigurableApplicationContext context = application.run(new String[0]);
        return context;
    }

    protected SpringApplication getSpringApplication() {
        return new SpringApplication(new Object[0]);
    }

    private Set<Object> getSources(MergedContextConfiguration mergedConfig) {
        LinkedHashSet<Object> sources = new LinkedHashSet<Object>();
        sources.addAll(Arrays.asList(mergedConfig.getClasses()));
        sources.addAll(Arrays.asList(mergedConfig.getLocations()));
        Assert.state((!sources.isEmpty() ? 1 : 0) != 0, (String)("No configuration classes or locations found in @SpringApplicationConfiguration. For default configuration detection to work you need Spring 4.0.3 or better (found " + SpringVersion.getVersion() + ")."));
        return sources;
    }

    private void setActiveProfiles(ConfigurableEnvironment environment, String[] profiles) {
        EnvironmentTestUtils.addEnvironment(environment, "spring.profiles.active=" + StringUtils.arrayToCommaDelimitedString((Object[])profiles));
    }

    protected String[] getInlinedProperties(MergedContextConfiguration config) {
        ArrayList<String> properties = new ArrayList<String>();
        this.disableJmx(properties);
        properties.addAll(Arrays.asList(config.getPropertySourceProperties()));
        if (!this.isEmbeddedWebEnvironment(config) && !this.hasCustomServerPort(properties)) {
            properties.add("server.port=-1");
        }
        return properties.toArray(new String[properties.size()]);
    }

    private void disableJmx(List<String> properties) {
        properties.add("spring.jmx.enabled=false");
    }

    private boolean hasCustomServerPort(List<String> properties) {
        PropertySources sources = this.convertToPropertySources(properties);
        RelaxedPropertyResolver resolver = new RelaxedPropertyResolver((PropertyResolver)new PropertySourcesPropertyResolver(sources), "server.");
        return resolver.containsProperty("port");
    }

    private PropertySources convertToPropertySources(List<String> properties) {
        Map source = TestPropertySourceUtils.convertInlinedPropertiesToMap((String[])properties.toArray(new String[properties.size()]));
        MutablePropertySources sources = new MutablePropertySources();
        sources.addFirst((PropertySource)new MapPropertySource("inline", source));
        return sources;
    }

    private List<ApplicationContextInitializer<?>> getInitializers(MergedContextConfiguration config, SpringApplication application) {
        ArrayList initializers = new ArrayList();
        for (ContextCustomizer contextCustomizer : config.getContextCustomizers()) {
            initializers.add(new ContextCustomizerAdapter(contextCustomizer, config));
        }
        initializers.addAll(application.getInitializers());
        for (Class initializerClass : config.getContextInitializerClasses()) {
            initializers.add((ApplicationContextInitializer<?>)BeanUtils.instantiate((Class)initializerClass));
        }
        if (config.getParent() != null) {
            initializers.add(new ParentContextApplicationContextInitializer(config.getParentApplicationContext()));
        }
        return initializers;
    }

    private boolean isEmbeddedWebEnvironment(MergedContextConfiguration config) {
        for (String annotation : INTEGRATION_TEST_ANNOTATIONS) {
            if (!AnnotatedElementUtils.isAnnotated((AnnotatedElement)config.getTestClass(), (String)annotation)) continue;
            return true;
        }
        SpringBootTest annotation = (SpringBootTest)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)config.getTestClass(), SpringBootTest.class);
        return annotation != null && annotation.webEnvironment().isEmbedded();
    }

    public void processContextConfiguration(ContextConfigurationAttributes configAttributes) {
        super.processContextConfiguration(configAttributes);
        if (!configAttributes.hasResources()) {
            Class[] defaultConfigClasses = this.detectDefaultConfigurationClasses(configAttributes.getDeclaringClass());
            configAttributes.setClasses(defaultConfigClasses);
        }
    }

    protected Class<?>[] detectDefaultConfigurationClasses(Class<?> declaringClass) {
        return AnnotationConfigContextLoaderUtils.detectDefaultConfigurationClasses(declaringClass);
    }

    public ApplicationContext loadContext(String ... locations) throws Exception {
        throw new UnsupportedOperationException("SpringApplicationContextLoader does not support the loadContext(String...) method");
    }

    protected String[] getResourceSuffixes() {
        return new String[]{"-context.xml", "Context.groovy"};
    }

    protected String getResourceSuffix() {
        throw new IllegalStateException();
    }

    static {
        LinkedHashSet<String> annotations = new LinkedHashSet<String>();
        annotations.add("org.springframework.boot.test.IntegrationTest");
        annotations.add("org.springframework.boot.test.WebIntegrationTest");
        INTEGRATION_TEST_ANNOTATIONS = Collections.unmodifiableSet(annotations);
    }

    @Order(value=-2147483648)
    private static class ParentContextApplicationContextInitializer
    implements ApplicationContextInitializer<ConfigurableApplicationContext> {
        private final ApplicationContext parent;

        ParentContextApplicationContextInitializer(ApplicationContext parent) {
            this.parent = parent;
        }

        public void initialize(ConfigurableApplicationContext applicationContext) {
            applicationContext.setParent(this.parent);
        }
    }

    private static class ContextCustomizerAdapter
    implements ApplicationContextInitializer<ConfigurableApplicationContext> {
        private final ContextCustomizer contextCustomizer;
        private final MergedContextConfiguration config;

        ContextCustomizerAdapter(ContextCustomizer contextCustomizer, MergedContextConfiguration config) {
            this.contextCustomizer = contextCustomizer;
            this.config = config;
        }

        public void initialize(ConfigurableApplicationContext applicationContext) {
            this.contextCustomizer.customizeContext(applicationContext, this.config);
        }
    }

    private static class WebConfigurer {
        private static final Class<GenericWebApplicationContext> WEB_CONTEXT_CLASS = GenericWebApplicationContext.class;

        private WebConfigurer() {
        }

        void configure(MergedContextConfiguration configuration, SpringApplication application, List<ApplicationContextInitializer<?>> initializers) {
            WebMergedContextConfiguration webConfiguration = (WebMergedContextConfiguration)configuration;
            this.addMockServletContext(initializers, webConfiguration);
            application.setApplicationContextClass(WEB_CONTEXT_CLASS);
        }

        private void addMockServletContext(List<ApplicationContextInitializer<?>> initializers, WebMergedContextConfiguration webConfiguration) {
            SpringBootMockServletContext servletContext = new SpringBootMockServletContext(webConfiguration.getResourceBasePath());
            initializers.add(0, (ApplicationContextInitializer<?>)new ServletContextApplicationContextInitializer((ServletContext)servletContext, true));
        }
    }
}

