/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.reactive.error;

import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.boot.autoconfigure.web.ErrorProperties;
import org.springframework.boot.autoconfigure.web.ResourceProperties;
import org.springframework.boot.autoconfigure.web.reactive.error.AbstractErrorWebExceptionHandler;
import org.springframework.boot.web.reactive.error.ErrorAttributes;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.server.RequestPredicate;
import org.springframework.web.reactive.function.server.RequestPredicates;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DefaultErrorWebExceptionHandler
extends AbstractErrorWebExceptionHandler {
    private static final Map<HttpStatus.Series, String> SERIES_VIEWS;
    private final ErrorProperties errorProperties;

    public DefaultErrorWebExceptionHandler(ErrorAttributes errorAttributes, ResourceProperties resourceProperties, ErrorProperties errorProperties, ApplicationContext applicationContext) {
        super(errorAttributes, resourceProperties, applicationContext);
        this.errorProperties = errorProperties;
    }

    @Override
    protected RouterFunction<ServerResponse> getRoutingFunction(ErrorAttributes errorAttributes) {
        return RouterFunctions.route((RequestPredicate)this.acceptsTextHtml(), this::renderErrorView).andRoute(RequestPredicates.all(), this::renderErrorResponse);
    }

    protected Mono<ServerResponse> renderErrorView(ServerRequest request) {
        boolean includeStackTrace = this.isIncludeStackTrace(request, MediaType.TEXT_HTML);
        Map<String, Object> error = this.getErrorAttributes(request, includeStackTrace);
        HttpStatus errorStatus = this.getHttpStatus(error);
        ServerResponse.BodyBuilder responseBody = ServerResponse.status((HttpStatus)errorStatus).contentType(MediaType.TEXT_HTML);
        return Flux.just((Object[])new String[]{"error/" + errorStatus.value(), "error/" + SERIES_VIEWS.get(errorStatus.series()), "error/error"}).flatMap(viewName -> this.renderErrorView((String)viewName, responseBody, error)).switchIfEmpty((Publisher)(this.errorProperties.getWhitelabel().isEnabled() ? this.renderDefaultErrorView(responseBody, error) : Mono.error((Throwable)this.getError(request)))).next();
    }

    protected Mono<ServerResponse> renderErrorResponse(ServerRequest request) {
        boolean includeStackTrace = this.isIncludeStackTrace(request, MediaType.ALL);
        Map<String, Object> error = this.getErrorAttributes(request, includeStackTrace);
        HttpStatus errorStatus = this.getHttpStatus(error);
        return ServerResponse.status((HttpStatus)this.getHttpStatus(error)).contentType(MediaType.APPLICATION_JSON_UTF8).body(BodyInserters.fromObject(error));
    }

    protected boolean isIncludeStackTrace(ServerRequest request, MediaType produces) {
        ErrorProperties.IncludeStacktrace include = this.errorProperties.getIncludeStacktrace();
        if (include == ErrorProperties.IncludeStacktrace.ALWAYS) {
            return true;
        }
        if (include == ErrorProperties.IncludeStacktrace.ON_TRACE_PARAM) {
            return this.isTraceEnabled(request);
        }
        return false;
    }

    protected HttpStatus getHttpStatus(Map<String, Object> errorAttributes) {
        int statusCode = (Integer)errorAttributes.get("status");
        return HttpStatus.valueOf((int)statusCode);
    }

    protected RequestPredicate acceptsTextHtml() {
        return serverRequest -> {
            try {
                List acceptedMediaTypes = serverRequest.headers().accept();
                acceptedMediaTypes.remove(MediaType.ALL);
                MediaType.sortBySpecificityAndQuality((List)acceptedMediaTypes);
                return acceptedMediaTypes.stream().anyMatch(arg_0 -> ((MediaType)MediaType.TEXT_HTML).isCompatibleWith(arg_0));
            }
            catch (InvalidMediaTypeException ex) {
                return false;
            }
        };
    }

    static {
        EnumMap<HttpStatus.Series, String> views = new EnumMap<HttpStatus.Series, String>(HttpStatus.Series.class);
        views.put(HttpStatus.Series.CLIENT_ERROR, "4xx");
        views.put(HttpStatus.Series.SERVER_ERROR, "5xx");
        SERIES_VIEWS = Collections.unmodifiableMap(views);
    }
}

