/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.socket.service;

import org.simpleframework.http.Request;
import org.simpleframework.http.Response;
import org.simpleframework.http.socket.Session;
import org.simpleframework.http.socket.service.Router;
import org.simpleframework.http.socket.service.Service;
import org.simpleframework.http.socket.service.ServiceEvent;
import org.simpleframework.http.socket.service.SessionBuilder;
import org.simpleframework.transport.Channel;
import org.simpleframework.transport.trace.Trace;

class SessionDispatcher {
    private final SessionBuilder builder;
    private final Router router;

    public SessionDispatcher(SessionBuilder builder, Router router) {
        this.builder = builder;
        this.router = router;
    }

    public void dispatch(Request request, Response response) {
        Channel channel = request.getChannel();
        Trace trace = channel.getTrace();
        try {
            Service service = this.router.route(request, response);
            Session session = this.builder.create(request, response);
            trace.trace((Object)ServiceEvent.DISPATCH_SOCKET);
            service.connect(session);
        }
        catch (Exception cause) {
            trace.trace((Object)ServiceEvent.ERROR, (Object)cause);
            this.terminate(request, response);
        }
    }

    public void terminate(Request request, Response response) {
        Channel channel = request.getChannel();
        Trace trace = channel.getTrace();
        try {
            response.close();
            channel.close();
            trace.trace((Object)ServiceEvent.TERMINATE_SOCKET);
        }
        catch (Exception cause) {
            trace.trace((Object)ServiceEvent.ERROR, (Object)cause);
        }
    }
}

