/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.socket.service;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.simpleframework.http.Request;
import org.simpleframework.http.socket.CloseCode;
import org.simpleframework.http.socket.Frame;
import org.simpleframework.http.socket.FrameListener;
import org.simpleframework.http.socket.FrameType;
import org.simpleframework.http.socket.Reason;
import org.simpleframework.http.socket.Session;
import org.simpleframework.http.socket.service.FrameConsumer;
import org.simpleframework.http.socket.service.FrameEncoder;
import org.simpleframework.http.socket.service.ReasonExtractor;
import org.simpleframework.http.socket.service.ServiceEvent;
import org.simpleframework.transport.ByteCursor;
import org.simpleframework.transport.Channel;
import org.simpleframework.transport.trace.Trace;

class FrameProcessor {
    private final Set<FrameListener> listeners = new CopyOnWriteArraySet<FrameListener>();
    private final ReasonExtractor extractor;
    private final FrameConsumer consumer;
    private final FrameEncoder encoder;
    private final AtomicBoolean closed;
    private final ByteCursor cursor;
    private final Session session;
    private final Channel channel;
    private final Reason normal = new Reason(CloseCode.NORMAL_CLOSURE);
    private final Trace trace;

    public FrameProcessor(FrameEncoder encoder, Session session, Request request) {
        this.extractor = new ReasonExtractor();
        this.consumer = new FrameConsumer();
        this.closed = new AtomicBoolean();
        this.channel = request.getChannel();
        this.cursor = this.channel.getCursor();
        this.trace = this.channel.getTrace();
        this.encoder = encoder;
        this.session = session;
    }

    public void register(FrameListener listener) {
        this.listeners.add(listener);
    }

    public void remove(FrameListener listener) {
        this.listeners.remove(listener);
    }

    public void process() throws IOException {
        if (this.cursor.isReady()) {
            this.consumer.consume(this.cursor);
            if (this.consumer.isFinished()) {
                Frame frame = this.consumer.getFrame();
                FrameType type = frame.getType();
                this.trace.trace((Object)ServiceEvent.READ_FRAME, (Object)type);
                if (type.isPong()) {
                    this.trace.trace((Object)ServiceEvent.READ_PONG);
                }
                if (type.isPing()) {
                    Frame response = frame.getFrame(FrameType.PONG);
                    this.trace.trace((Object)ServiceEvent.READ_PING);
                    this.encoder.encode(response);
                    this.trace.trace((Object)ServiceEvent.WRITE_PONG);
                }
                for (FrameListener listener : this.listeners) {
                    listener.onFrame(this.session, frame);
                }
                if (type.isClose()) {
                    Reason reason = this.extractor.extract(frame);
                    if (reason != null) {
                        this.close(reason);
                    } else {
                        this.close();
                    }
                }
                this.consumer.clear();
            }
        }
    }

    public void failure(Exception reason) throws IOException {
        if (!this.closed.getAndSet(true)) {
            for (FrameListener listener : this.listeners) {
                try {
                    listener.onError(this.session, reason);
                }
                catch (Exception cause) {
                    this.trace.trace((Object)ServiceEvent.ERROR, (Object)cause);
                }
            }
        }
    }

    public void close(Reason reason) throws IOException {
        if (!this.closed.getAndSet(true)) {
            for (FrameListener listener : this.listeners) {
                try {
                    listener.onClose(this.session, reason);
                }
                catch (Exception cause) {
                    this.trace.trace((Object)ServiceEvent.ERROR, (Object)cause);
                }
            }
        }
    }

    public void close() throws IOException {
        if (!this.closed.getAndSet(true)) {
            try {
                for (FrameListener listener : this.listeners) {
                    listener.onClose(this.session, this.normal);
                }
            }
            catch (Exception cause) {
                this.trace.trace((Object)ServiceEvent.ERROR, (Object)cause);
            }
        }
    }
}

