/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.socket.service;

import java.util.Arrays;
import org.simpleframework.http.socket.DataConverter;
import org.simpleframework.http.socket.DataFrame;
import org.simpleframework.http.socket.Frame;
import org.simpleframework.http.socket.FrameType;
import org.simpleframework.http.socket.service.FrameHeader;

class FrameBuilder {
    private final DataConverter converter = new DataConverter();
    private final FrameHeader header;

    public FrameBuilder(FrameHeader header) {
        this.header = header;
    }

    public Frame create(byte[] data, int count) {
        FrameType type = this.header.getType();
        if (type.isText()) {
            return this.createText(data, count);
        }
        return this.createBinary(data, count);
    }

    private Frame createText(byte[] data, int count) {
        FrameType type = this.header.getType();
        String text = this.converter.convert(data, 0, count);
        if (this.header.isFinal()) {
            return new DataFrame(type, text, true);
        }
        return new DataFrame(type, text, false);
    }

    private Frame createBinary(byte[] data, int count) {
        FrameType type = this.header.getType();
        byte[] copy = Arrays.copyOf(data, count);
        if (this.header.isFinal()) {
            return new DataFrame(type, copy, true);
        }
        return new DataFrame(type, copy, false);
    }
}

