/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.message;

import java.io.IOException;
import org.simpleframework.common.buffer.Allocator;
import org.simpleframework.common.buffer.Buffer;
import org.simpleframework.http.Part;
import org.simpleframework.http.message.Body;
import org.simpleframework.http.message.BufferBody;
import org.simpleframework.http.message.BufferPart;
import org.simpleframework.http.message.PartSeries;
import org.simpleframework.http.message.Segment;
import org.simpleframework.http.message.UpdateConsumer;
import org.simpleframework.transport.ByteCursor;

class ContentConsumer
extends UpdateConsumer {
    private static final byte[] START = new byte[]{13, 10, 45, 45};
    private PartSeries series;
    private Allocator allocator;
    private Segment segment;
    private Buffer buffer;
    private byte[] boundary;
    private int start;
    private int seek;

    public ContentConsumer(Allocator allocator, Segment segment, PartSeries series, byte[] boundary) {
        this.allocator = allocator;
        this.boundary = boundary;
        this.segment = segment;
        this.series = series;
    }

    public Body getBody() {
        return new BufferBody(this.buffer);
    }

    public Part getPart() {
        return new BufferPart(this.segment, this.buffer);
    }

    private void append(byte[] array, int off, int len) throws IOException {
        if (this.buffer == null) {
            this.buffer = this.allocator.allocate();
        }
        this.buffer.append(array, off, len);
    }

    protected void commit(ByteCursor cursor) throws IOException {
        cursor.push(this.boundary);
        cursor.push(START);
    }

    protected int update(byte[] array, int off, int size) throws IOException {
        int excess;
        int skip = this.start + this.seek;
        int last = off + size;
        int next = this.start;
        int mark = off;
        while (off < last) {
            byte octet;
            if (this.start == START.length) {
                Part part;
                if (array[off++] != this.boundary[this.seek++]) {
                    if (skip > 0) {
                        this.append(START, 0, next);
                        this.append(this.boundary, 0, skip - next);
                    }
                    this.seek = 0;
                    this.start = 0;
                    skip = 0;
                }
                if (this.seek != this.boundary.length) continue;
                excess = this.seek + this.start;
                int total = off - mark;
                int valid = total - excess;
                this.finished = true;
                if (valid > 0) {
                    this.append(array, mark, valid);
                }
                if ((part = this.getPart()) != null) {
                    this.series.addPart(part);
                }
                return size - total;
            }
            if ((octet = array[off++]) == START[this.start++]) continue;
            if (skip > 0) {
                this.append(START, 0, next);
            }
            this.start = 0;
            skip = 0;
            if (octet != START[0]) continue;
            ++this.start;
        }
        int total = off - mark;
        excess = this.seek + this.start;
        int valid = total - excess;
        if (valid > 0) {
            this.append(array, mark, valid);
        }
        return 0;
    }
}

