
create table ODE_SCHEMA_VERSION(VERSION integer);
insert into ODE_SCHEMA_VERSION values (220);

CREATE TABLE ODE_JOB (
  jobid varchar(64)  NOT NULL,
  ts BIGINT  NOT NULL,
  nodeid varchar(64),
  scheduled smallint  NOT NULL,
  transacted smallint  NOT NULL,

  instanceId BIGINT,
  mexId varchar(255),
  processId varchar(255),
  type varchar(255),
  channel varchar(255),
  correlatorId varchar(255),
  correlationKeySet varchar(255),
  retryCount integer,
  inMem smallint,
  detailsExt blob(4096),

  PRIMARY KEY(jobid));

CREATE INDEX IDX_ODE_JOB_TS ON ODE_JOB(ts);
CREATE INDEX IDX_ODE_JOB_NODEID ON ODE_JOB(nodeid);

create table BPEL_ACTIVITY_RECOVERY (
   ID bigint generated by default as identity,
   ACTIONS varchar(255),
   ACTIVITY_ID bigint,
   CHANNEL varchar(255),
   DATE_TIME timestamp,
   DETAILS clob(4000),
   INSTANCE_ID bigint,
   REASON varchar(255),
   RETRIES integer,
   primary key (ID)
);

create table BPEL_CORRELATION_SET (
   CORRELATION_SET_ID bigint generated by default as identity,
   CORRELATION_KEY varchar(255),
   NAME varchar(255),
   SCOPE_ID bigint,
   primary key (CORRELATION_SET_ID)
);

create table BPEL_CORRELATOR (
   CORRELATOR_ID bigint generated by default as identity,
   CORRELATOR_KEY varchar(255),
   PROC_ID bigint,
   primary key (CORRELATOR_ID)
);

create table BPEL_CORSET_PROP (
   ID bigint generated by default as identity,
   CORRSET_ID bigint,
   PROP_KEY varchar(255),
   PROP_VALUE varchar(255),
   primary key (ID)
);

create table BPEL_EVENT (
   EVENT_ID bigint generated by default as identity,
   DETAIL varchar(255),
   DATA blob(4096),
   SCOPE_ID bigint,
   TSTAMP timestamp,
   TYPE varchar(255),
   INSTANCE_ID bigint,
   PROCESS_ID bigint,
   primary key (EVENT_ID)
);

create table BPEL_FAULT (
   FAULT_ID bigint generated by default as identity,
   ACTIVITY_ID integer,
   DATA clob(4000),
   MESSAGE varchar(102400),
   LINE_NUMBER integer,
   NAME varchar(255),
   primary key (FAULT_ID)
);

create table BPEL_MESSAGE (
   MESSAGE_ID bigint generated by default as identity,
   DATA clob(4000),
   HEADER clob(4000),
   TYPE varchar(255),
   MESSAGE_EXCHANGE_ID varchar(255),
   primary key (MESSAGE_ID)
);

create table BPEL_MESSAGE_EXCHANGE (
   MESSAGE_EXCHANGE_ID varchar(255) not null,
   CALLEE varchar(255),
   CHANNEL varchar(255),
   CORRELATION_ID varchar(255),
   CORRELATION_KEYS varchar(255),
   CORRELATION_STATUS varchar(255),
   CREATE_TIME timestamp,
   DIRECTION char(1),
   EPR clob(4000),
   FAULT varchar(255),
   FAULT_EXPLANATION varchar(255),
   OPERATION varchar(255),
   PARTNER_LINK_MODEL_ID integer,
   PATTERN varchar(255),
   PIPED_ID varchar(255),
   PORT_TYPE varchar(255),
   PROPAGATE_TRANS smallint,
   STATUS varchar(255),
   SUBSCRIBER_COUNT integer,
   CORR_ID bigint,
   PARTNER_LINK_ID bigint,
   PROCESS_ID bigint,
   PROCESS_INSTANCE_ID bigint,
   REQUEST_MESSAGE_ID bigint,
   RESPONSE_MESSAGE_ID bigint,
   primary key (MESSAGE_EXCHANGE_ID)
);

create table BPEL_MESSAGE_ROUTE (
   MESSAGE_ROUTE_ID bigint generated by default as identity,
   CORRELATION_KEY varchar(255),
   GROUP_ID varchar(255),
   ROUTE_INDEX integer,
   PROCESS_INSTANCE_ID bigint,
   ROUTE_POLICY varchar(16),
   CORR_ID bigint,
   primary key (MESSAGE_ROUTE_ID)
);

create table BPEL_MEX_PROP (
   ID bigint generated by default as identity,
   MEX_ID varchar(255),
   PROP_KEY varchar(255),
   PROP_VALUE varchar(2000),
   primary key (ID)
);

create table BPEL_PARTNER_LINK (
   PARTNER_LINK_ID bigint generated by default as identity,
   MY_EPR clob(4000),
   MY_ROLE_NAME varchar(255),
   MY_ROLE_SERVICE_NAME varchar(255),
   MY_SESSION_ID varchar(255),
   PARTNER_EPR clob(4000),
   PARTNER_LINK_MODEL_ID integer,
   PARTNER_LINK_NAME varchar(255),
   PARTNER_ROLE_NAME varchar(255),
   PARTNER_SESSION_ID varchar(255),
   SCOPE_ID bigint,
   primary key (PARTNER_LINK_ID)
);

create table BPEL_PROCESS (
   ID bigint generated by default as identity,
   GUID varchar(255),
   PROCESS_ID varchar(255),
   PROCESS_TYPE varchar(255),
   VERSION bigint,
   primary key (ID)
);

create table BPEL_PROCESS_INSTANCE (
   ID bigint generated by default as identity,
   DATE_CREATED timestamp,
   EXECUTION_STATE blob(4096),
   FAULT_ID bigint,
   LAST_ACTIVE_TIME timestamp,
   LAST_RECOVERY_DATE timestamp,
   PREVIOUS_STATE smallint,
   SEQUENCE bigint,
   INSTANCE_STATE smallint,
   INSTANTIATING_CORRELATOR_ID bigint,
   PROCESS_ID bigint,
   ROOT_SCOPE_ID bigint,
   primary key (ID)
);

create table BPEL_SCOPE (
   SCOPE_ID bigint generated by default as identity,
   MODEL_ID integer,
   SCOPE_NAME varchar(255),
   SCOPE_STATE varchar(255),
   PARENT_SCOPE_ID bigint,
   PROCESS_INSTANCE_ID bigint,
   primary key (SCOPE_ID)
);

create table BPEL_XML_DATA (
   XML_DATA_ID bigint generated by default as identity,
   DATA clob(4000),
   IS_SIMPLE_TYPE smallint,
   NAME varchar(255),
   SCOPE_ID bigint,
   primary key (XML_DATA_ID)
);

create table BPEL_XML_DATA_PROP (
   ID bigint generated by default as identity,
   XML_DATA_ID bigint,
   PROP_KEY varchar(255),
   PROP_VALUE varchar(255),
   primary key (ID)
);

create table STORE_DU (
   NAME varchar(255) not null,
   DEPLOYDT timestamp,
   DEPLOYER varchar(255),
   DIR varchar(255),
   primary key (NAME)
);

create table STORE_PROCESS (
   PID varchar(255) not null,
   STATE varchar(255),
   TYPE varchar(255),
   VERSION bigint,
   DU varchar(255),
   primary key (PID)
);

create table STORE_PROCESS_PROP (
   ID bigint generated by default as identity,
   PROP_KEY varchar(255),
   PROP_VAL varchar(255),
   primary key (ID)
);

create table STORE_PROC_TO_PROP (
   STORE_PROCESS_PID varchar(255) not null,
   STORE_PROPERTY_ID bigint not null,
   primary key (STORE_PROCESS_PID, STORE_PROPERTY_ID),
   unique (STORE_PROPERTY_ID)
);

create table STORE_VERSIONS (
   ID bigint generated by default as identity,
   VERSION bigint,
   primary key (ID)
);

create table BPAF_EVENT (
    EID bigint generated by default as identity,
    ACTIVITY_DEFINITION_ID varchar(255),
    ACTIVITY_INSTANCE_ID varchar(255),
    ACTIVITY_NAME varchar(255),
    CURRENT_STATE varchar(255),
    PREVIOUS_STATE varchar(255),
    PROCESS_DEFINITION_ID varchar(255),
    PROCESS_INSTANCE_ID varchar(255),
    PROCESS_NAME varchar(255),
    SERVER_ID varchar(255),
    TIMESTAMP bigint,
    primary key (EID)
    );

create table BPAF_EVENT_DATA (
    TID bigint generated by default as identity,
    NAME varchar(255),
    VALUE clob(4000),
    EVENT_ID bigint,
    primary key (TID)
);

alter table BPAF_EVENT_DATA
    add constraint FK3E83D1BCDA848C8
    foreign key (EVENT_ID)
    references BPAF_EVENT;
