/*
 * Decompiled with CFR 0.152.
 */
package org.riftsaw.engine.internal;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.evt.DebugBpelEventListener;
import org.apache.ode.bpel.engine.BpelManagementFacadeImpl;
import org.apache.ode.bpel.engine.BpelServerImpl;
import org.apache.ode.bpel.engine.CountLRUDehydrationPolicy;
import org.apache.ode.bpel.engine.DehydrationPolicy;
import org.apache.ode.bpel.engine.cron.CronScheduler;
import org.apache.ode.bpel.evar.ExternalVariableModule;
import org.apache.ode.bpel.evt.BpelEvent;
import org.apache.ode.bpel.extvar.jdbc.JdbcExternalVariableModule;
import org.apache.ode.bpel.iapi.BindingContext;
import org.apache.ode.bpel.iapi.BpelEventListener;
import org.apache.ode.bpel.iapi.BpelServer;
import org.apache.ode.bpel.iapi.CacheProvider;
import org.apache.ode.bpel.iapi.EndpointReferenceContext;
import org.apache.ode.bpel.iapi.Message;
import org.apache.ode.bpel.iapi.MessageExchangeContext;
import org.apache.ode.bpel.iapi.MyRoleMessageExchange;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.iapi.ProcessStore;
import org.apache.ode.bpel.iapi.ProcessStoreEvent;
import org.apache.ode.bpel.iapi.ProcessStoreListener;
import org.apache.ode.bpel.iapi.Scheduler;
import org.apache.ode.bpel.intercept.MessageExchangeInterceptor;
import org.apache.ode.bpel.memdao.BpelDAOConnectionFactoryImpl;
import org.apache.ode.bpel.pmapi.BpelManagementFacade;
import org.apache.ode.dao.bpel.BpelDAOConnectionFactory;
import org.apache.ode.dao.scheduler.SchedulerDAOConnectionFactory;
import org.apache.ode.dao.store.ConfStoreDAOConnectionFactory;
import org.apache.ode.il.cache.CacheProviderFactory;
import org.apache.ode.il.config.OdeConfigProperties;
import org.apache.ode.il.dbutil.Database;
import org.apache.ode.scheduler.simple.SimpleScheduler;
import org.apache.ode.store.RiftSawProcessStore;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.GUID;
import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.riftsaw.engine.BPELEngine;
import org.riftsaw.engine.BPELEngineListener;
import org.riftsaw.engine.DeploymentRef;
import org.riftsaw.engine.DeploymentUnit;
import org.riftsaw.engine.Fault;
import org.riftsaw.engine.ServiceLocator;
import org.riftsaw.engine.internal.DatabaseInitialiser;
import org.riftsaw.engine.internal.DeploymentManager;
import org.riftsaw.engine.internal.DeploymentRefImpl;
import org.riftsaw.engine.internal.EndpointReferenceContextImpl;
import org.riftsaw.engine.internal.MemberDropListener;
import org.riftsaw.engine.internal.MessageExchangeContextImpl;
import org.riftsaw.engine.internal.RiftsawBindingContext;
import org.riftsaw.engine.jboss.JndiRegistry;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BPELEngineImpl
implements BPELEngine {
    private static final Log LOG = LogFactory.getLog(BPELEngineImpl.class);
    private static final String _jndiName = "java:jboss/BPELEngine";
    private static final String _emfJndiName = "java:jboss/BPELEMFactory";
    private static final String DEPLOYMENT_FOLDER_ENV_VAR = "jboss.server.temp.dir";
    private BpelServerImpl _bpelServer;
    private RiftSawProcessStore _store;
    private OdeConfigProperties _odeConfig;
    private TransactionManager _txMgr;
    private BpelDAOConnectionFactory _daoCF;
    private ConfStoreDAOConnectionFactory _storeCF;
    private SchedulerDAOConnectionFactory _schedulerDaoCF;
    private Scheduler _scheduler;
    private Database _db;
    private ExecutorService _executorService;
    private CronScheduler _cronScheduler;
    private CacheProvider _cacheProvider;
    private Cache<String, String> _cache;
    private ServiceLocator _serviceLocator;
    private DeploymentManager _deploymentManager;
    private Map<BPELEngineListener, ProxyBpelEventListener> _listeners = new HashMap<BPELEngineListener, ProxyBpelEventListener>();

    @Override
    public void init(ServiceLocator locator, Properties props) throws Exception {
        if (props == null) {
            props = new Properties();
        }
        LOG.info((Object)("ODE PROPS=" + props));
        this._odeConfig = new OdeConfigProperties(props, "bpel.");
        this._serviceLocator = locator;
        LOG.info((Object)"Initializing transaction manager");
        this.initTxMgr();
        LOG.info((Object)"Creating data source.");
        this.initDataSource();
        this.populateDatabaseSchema();
        LOG.info((Object)"Starting DAO.");
        this.initDAO();
        LOG.info((Object)"Initializing deployment manager");
        this.initDeploymentManager();
        EndpointReferenceContextImpl eprContext = new EndpointReferenceContextImpl(this);
        this.initCacheProvider();
        LOG.info((Object)"Initializing BPEL process store.");
        this.initProcessStore(eprContext);
        LOG.info((Object)"Initializing UDDI registration");
        LOG.info((Object)"Initializing BPEL server.");
        this.initBpelServer(eprContext, locator);
        this._store.loadAll();
        this.registerEventListeners();
        this.registerMexInterceptors();
        this.registerExternalVariableModules();
        try {
            this._bpelServer.start();
        }
        catch (Exception ex) {
            String errmsg = "SERVER START FAILED";
            LOG.error((Object)errmsg, (Throwable)ex);
        }
        LOG.info((Object)"Starting scheduler");
        this._scheduler.start();
        this.RegisterServicesIntoJNDI();
    }

    private void populateDatabaseSchema() throws Exception {
        if (!Boolean.valueOf(this._odeConfig.getProperty("db.emb.create", "false")).booleanValue()) {
            String dialect = this._odeConfig.getProperties().getProperty("hibernate.dialect");
            DatabaseInitialiser dbInitialiser = new DatabaseInitialiser(this._db.getDataSource(), this._txMgr, dialect);
            dbInitialiser.initDatabase();
        }
    }

    private void RegisterServicesIntoJNDI() {
        LOG.info((Object)"Register BPEL engine, EntityManagerFactory into JNDI.");
        JndiRegistry.bindToJndi(_jndiName, this);
        Object emf = this._odeConfig.getProperties().get("ode.emf");
        if (emf != null) {
            JndiRegistry.bindToJndi(_emfJndiName, emf);
        }
    }

    private void unregisterServicesFromJNDI() {
        LOG.info((Object)"Unbind the services from JNDI.");
        try {
            JndiRegistry.unbindFromJndi(_jndiName);
            JndiRegistry.unbindFromJndi(_emfJndiName);
        }
        catch (Throwable t) {
            LOG.debug((Object)"Failed to unbind services on engine close", t);
        }
    }

    @Override
    public ServiceLocator getServiceLocator() {
        return this._serviceLocator;
    }

    protected void initProcessStore(EndpointReferenceContext eprContext) {
        this._store = this.createProcessStore(eprContext, this._txMgr, this._storeCF);
        this._store.registerListener(new ProcessStoreListenerImpl());
    }

    protected RiftSawProcessStore createProcessStore(EndpointReferenceContext eprContext, TransactionManager txm, ConfStoreDAOConnectionFactory cf) {
        return new RiftSawProcessStore(eprContext, txm, cf, this._cacheProvider);
    }

    private void initCacheProvider() {
        this._cacheProvider = CacheProviderFactory.getCacheProvider((OdeConfigProperties)this._odeConfig);
        try {
            this._cacheProvider.start(this._odeConfig.getProperties());
        }
        catch (Exception e) {
            LOG.error((Object)"Error in starting cache provider", (Throwable)e);
            throw new RuntimeException("Error in initCacheProvider.", e);
        }
    }

    private void initDeploymentManager() {
        this._deploymentManager = new DeploymentManager();
        String folder = this._odeConfig.getProperty("deployment.folder");
        if (folder == null) {
            folder = System.getProperty(DEPLOYMENT_FOLDER_ENV_VAR);
        }
        if (folder != null) {
            this._deploymentManager.setDeploymentFolder(folder);
        }
    }

    private void initDataSource() throws Exception {
        this._db = new Database(this._odeConfig);
        this._db.setTransactionManager(this._txMgr);
        try {
            this._db.start();
        }
        catch (Exception ex) {
            String errmsg = "FAILED TO INITIALISE DATA SOURCE";
            LOG.error((Object)errmsg, (Throwable)ex);
            throw new Exception(errmsg, ex);
        }
    }

    private void initTxMgr() throws Exception {
        String txFactoryName = this._odeConfig.getTxFactoryClass();
        LOG.info((Object)("Initializing transaction manager using " + txFactoryName));
        try {
            Class<?> txFactClass = this.getClass().getClassLoader().loadClass(txFactoryName);
            Object txFact = txFactClass.newInstance();
            this._txMgr = (TransactionManager)txFactClass.getMethod("getTransactionManager", null).invoke(txFact, new Object[0]);
        }
        catch (Exception e) {
            LOG.error((Object)("Couldn't initialize a transaction manager with factory: " + txFactoryName), (Throwable)e);
            throw new Exception("Couldn't initialize a transaction manager with factory: " + txFactoryName, e);
        }
    }

    protected void initDAO() throws Exception {
        LOG.info((Object)("USING DAO: " + this._odeConfig.getDAOConnectionFactory() + ", " + this._odeConfig.getDAOConfStoreConnectionFactory() + ", " + this._odeConfig.getDAOConfScheduleConnectionFactory()));
        try {
            this._daoCF = this._db.createDaoCF();
            this._storeCF = this._db.createDaoStoreCF();
            this._schedulerDaoCF = this._db.createDaoSchedulerCF();
        }
        catch (Exception ex) {
            String errmsg = "DAO INSTANTIATION FAILED: " + this._odeConfig.getDAOConnectionFactory() + " , " + this._odeConfig.getDAOConfStoreConnectionFactory() + " and " + this._odeConfig.getDAOConfScheduleConnectionFactory();
            LOG.error((Object)errmsg, (Throwable)ex);
            throw new Exception(errmsg, ex);
        }
    }

    protected Scheduler createScheduler() {
        String clusterNodeName = this._odeConfig.getProperty("riftsaw.node.name", "non-cluster-node");
        String cacheName = this._odeConfig.getProperty("cache-name", "cluster");
        try {
            EmbeddedCacheManager ecm = (EmbeddedCacheManager)new InitialContext().lookup("java:jboss/infinispan/container/" + cacheName);
            clusterNodeName = ecm.getAddress().toString();
            this._cache = ecm.getCache();
            this._cache.start();
            ecm.addListener((Object)new MemberDropListener(this._schedulerDaoCF, this._txMgr));
        }
        catch (NamingException e) {
            LOG.info((Object)"RiftSaw (BPEL Component) will be started in the non cluster environment.");
        }
        LOG.info((Object)("The schduler node name is: " + clusterNodeName));
        SimpleScheduler scheduler = new SimpleScheduler(clusterNodeName, this._schedulerDaoCF, this._txMgr, this._odeConfig.getProperties());
        scheduler.setExecutorService(this._executorService);
        scheduler.setTransactionManager(this._txMgr);
        return scheduler;
    }

    private void initBpelServer(EndpointReferenceContextImpl eprContext, ServiceLocator locator) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"ODE initializing");
        }
        ThreadFactory threadFactory = new ThreadFactory(){
            private int _threadNumber = 0;

            @Override
            public Thread newThread(Runnable r) {
                ++this._threadNumber;
                Thread t = new Thread(r, "ODEServer-" + this._threadNumber);
                t.setDaemon(true);
                return t;
            }
        };
        this._executorService = this._odeConfig.getThreadPoolMaxSize() == 0 ? Executors.newCachedThreadPool(threadFactory) : Executors.newFixedThreadPool(this._odeConfig.getThreadPoolMaxSize(), threadFactory);
        this._bpelServer = new BpelServerImpl();
        this._scheduler = this.createScheduler();
        this._scheduler.setJobProcessor((Scheduler.JobProcessor)this._bpelServer);
        BpelServerImpl.PolledRunnableProcessor polledRunnableProcessor = new BpelServerImpl.PolledRunnableProcessor();
        polledRunnableProcessor.setPolledRunnableExecutorService(this._executorService);
        polledRunnableProcessor.setContexts(this._bpelServer.getContexts());
        this._scheduler.setPolledRunnableProcesser((Scheduler.JobProcessor)polledRunnableProcessor);
        this._cronScheduler = new CronScheduler();
        this._cronScheduler.setScheduledTaskExec(this._executorService);
        this._cronScheduler.setContexts(this._bpelServer.getContexts());
        this._bpelServer.setCronScheduler(this._cronScheduler);
        this._bpelServer.setDaoConnectionFactory(this._daoCF);
        this._bpelServer.setInMemDaoConnectionFactory((BpelDAOConnectionFactory)new BpelDAOConnectionFactoryImpl(this._scheduler, this._odeConfig.getInMemMexTtl()));
        this._bpelServer.setEndpointReferenceContext((EndpointReferenceContext)eprContext);
        this._bpelServer.setMessageExchangeContext((MessageExchangeContext)new MessageExchangeContextImpl(locator));
        this._bpelServer.setBindingContext((BindingContext)new RiftsawBindingContext());
        this._bpelServer.setScheduler(this._scheduler);
        if (this._odeConfig.isDehydrationEnabled()) {
            CountLRUDehydrationPolicy dehy = new CountLRUDehydrationPolicy();
            dehy.setProcessMaxAge(this._odeConfig.getDehydrationMaximumAge());
            dehy.setProcessMaxCount(this._odeConfig.getDehydrationMaximumCount());
            this._bpelServer.setDehydrationPolicy((DehydrationPolicy)dehy);
        }
        this._bpelServer.setConfigProperties(this._odeConfig.getProperties());
        this._bpelServer.init();
        this._bpelServer.setInstanceThrottledMaximumCount(this._odeConfig.getInstanceThrottledMaximumCount());
        this._bpelServer.setProcessThrottledMaximumCount(this._odeConfig.getProcessThrottledMaximumCount());
        this._bpelServer.setProcessThrottledMaximumSize(this._odeConfig.getProcessThrottledMaximumSize());
        this._bpelServer.setHydrationLazy(this._odeConfig.isHydrationLazy());
        this._bpelServer.setHydrationLazyMinimumSize(this._odeConfig.getHydrationLazyMinimumSize());
        this._bpelServer.setXTSEnable(this._odeConfig.isXTSEnable());
    }

    @Override
    public void deploy(DeploymentUnit bdu) throws Exception {
        this._store.deploy(bdu);
    }

    @Override
    public void undeploy(DeploymentUnit bdu) throws Exception {
        this._store.undeploy(bdu);
    }

    @Override
    public DeploymentRef deploy(File deployment) throws Exception {
        return this.deploy(deployment.getName(), deployment);
    }

    @Override
    public DeploymentRef deploy(String name, File deployment) throws Exception {
        DeploymentRefImpl ret = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Deploying: " + name + " at: " + deployment));
        }
        List<DeploymentUnit> dus = null;
        try {
            dus = this._deploymentManager.getDeploymentUnits(name, deployment);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to get deployment units from '" + deployment + "'"), (Throwable)e);
            throw e;
        }
        for (DeploymentUnit du : dus) {
            try {
                this._store.deploy(du);
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to deploy '" + du.getName() + "'"), (Throwable)e);
                for (DeploymentUnit du2 : dus) {
                    if (du == du2) break;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Undeploying '" + du2.getName() + "' after failure when deploying '" + du.getName() + "'"));
                    }
                    this._store.undeploy(du2);
                }
                throw e;
            }
        }
        ret = new DeploymentRefImpl(dus);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Deployed: " + deployment + " ref=" + ret));
        }
        return ret;
    }

    @Override
    public void undeploy(DeploymentRef ref) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Undeploying ref: " + ref));
        }
        if (ref instanceof DeploymentRefImpl) {
            for (int i = 0; i < ((DeploymentRefImpl)ref).getDeploymentUnits().size(); ++i) {
                DeploymentUnit du = ((DeploymentRefImpl)ref).getDeploymentUnits().get(i);
                if (this._store == null) continue;
                this._store.undeploy(du);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        block39: {
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            try {
                if (this._bpelServer == null) break block39;
                try {
                    LOG.debug((Object)"shutting down BPEL server.");
                    this._bpelServer.shutdown();
                    this._bpelServer = null;
                }
                catch (Throwable ex) {
                    LOG.debug((Object)"Error stopping services.", ex);
                }
                if (this._cronScheduler != null) {
                    try {
                        LOG.debug((Object)"shutting down cron scheduler.");
                        this._cronScheduler.shutdown();
                        this._cronScheduler = null;
                    }
                    catch (Exception ex) {
                        LOG.debug((Object)"Cron scheduler couldn't be shutdown.", (Throwable)ex);
                    }
                }
                if (this._scheduler != null) {
                    try {
                        LOG.debug((Object)"shutting down scheduler.");
                        this._scheduler.shutdown();
                        this._scheduler = null;
                    }
                    catch (Exception ex) {
                        LOG.debug((Object)"Scheduler couldn't be shutdown.", (Throwable)ex);
                    }
                }
                if (this._store != null) {
                    try {
                        this._store.shutdown();
                        this._store = null;
                    }
                    catch (Throwable t) {
                        LOG.debug((Object)"Store could not be shutdown.", t);
                    }
                }
                this._cacheProvider.stop();
                if (this._daoCF != null) {
                    try {
                        this._daoCF.shutdown();
                    }
                    catch (Throwable ex) {
                        LOG.debug((Object)"Bpel DAO shutdown failed.", ex);
                    }
                    finally {
                        this._daoCF = null;
                    }
                }
                if (this._storeCF != null) {
                    try {
                        this._storeCF.shutdown();
                    }
                    catch (Throwable ex) {
                        LOG.debug((Object)"Store DAO shutdown failed.", ex);
                    }
                    finally {
                        this._storeCF = null;
                    }
                }
                if (this._schedulerDaoCF != null) {
                    try {
                        this._schedulerDaoCF.shutdown();
                    }
                    catch (Throwable ex) {
                        LOG.debug((Object)"Scheduler DAO shutdown failed.", ex);
                    }
                    finally {
                        this._schedulerDaoCF = null;
                    }
                }
                if (this._db != null) {
                    try {
                        this._db.shutdown();
                    }
                    catch (Throwable ex) {
                        LOG.debug((Object)"DB shutdown failed.", ex);
                    }
                    finally {
                        this._db = null;
                    }
                }
                if (this._txMgr != null) {
                    LOG.debug((Object)"shutting down transaction manager.");
                    this._txMgr = null;
                }
                this.unregisterServicesFromJNDI();
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
    }

    private void registerEventListeners() {
        this._bpelServer.registerBpelEventListener((BpelEventListener)new DebugBpelEventListener());
        String listenersStr = this._odeConfig.getEventListeners();
        if (listenersStr != null) {
            StringTokenizer tokenizer = new StringTokenizer(listenersStr, ",;");
            while (tokenizer.hasMoreTokens()) {
                String listenerCN = tokenizer.nextToken();
                try {
                    this._bpelServer.registerBpelEventListener((BpelEventListener)Class.forName(listenerCN).newInstance());
                    LOG.debug((Object)("REGISTERED EVENT LISTENER: " + listenerCN));
                }
                catch (Exception e) {
                    LOG.warn((Object)("Couldn't register the event listener " + listenerCN + ", the class couldn't be " + "loaded properly: " + e));
                }
            }
        }
    }

    private void registerMexInterceptors() {
        String listenersStr = this._odeConfig.getMessageExchangeInterceptors();
        if (listenersStr != null) {
            StringTokenizer tokenizer = new StringTokenizer(listenersStr, ",;");
            while (tokenizer.hasMoreTokens()) {
                String interceptorCN = tokenizer.nextToken();
                try {
                    this._bpelServer.registerMessageExchangeInterceptor((MessageExchangeInterceptor)Class.forName(interceptorCN).newInstance());
                    LOG.debug((Object)("MESSAGE EXCHANGE INTERCEPTOR REGISTERED: " + interceptorCN));
                }
                catch (Exception e) {
                    LOG.warn((Object)("Couldn't register the event listener " + interceptorCN + ", the class couldn't be " + "loaded properly: " + e));
                }
            }
        }
    }

    private void registerExternalVariableModules() {
        JdbcExternalVariableModule jdbcext = new JdbcExternalVariableModule();
        jdbcext.registerDataSource("ode", this._db.getDataSource());
        this._bpelServer.registerExternalVariableEngine((ExternalVariableModule)jdbcext);
    }

    private void handleEvent(ProcessStoreEvent pse) {
        LOG.debug((Object)("Process store event: " + pse));
        ProcessConf pconf = this._store.getProcessConfiguration(pse.pid);
        switch (pse.type) {
            case DEPLOYED: {
                if (pconf == null) break;
                this._bpelServer.cleanupProcess(pconf);
                break;
            }
            case ACTVIATED: {
                this._bpelServer.unregister(pse.pid);
                if (pconf != null) {
                    this._bpelServer.register(pconf);
                    break;
                }
                LOG.debug((Object)("slighly odd: recevied event " + pse + " for process not in store!"));
                break;
            }
            case RETIRED: {
                boolean instantiated = this._bpelServer.hasActiveInstances(pse.pid);
                this._bpelServer.unregister(pse.pid);
                if (instantiated) {
                    if (pconf != null) {
                        this._bpelServer.register(pconf);
                        break;
                    }
                    LOG.debug((Object)("slighly odd: recevied event " + pse + " for process not in store!"));
                    break;
                }
                if (pconf == null) break;
                this._bpelServer.cleanupProcess(pconf);
                break;
            }
            case DISABLED: 
            case UNDEPLOYED: {
                String retiredProcess;
                this._bpelServer.unregister(pse.pid);
                if (pconf != null) {
                    this._bpelServer.cleanupProcess(pconf);
                }
                if ((retiredProcess = this._store.getLatestPackageVersion(pse.deploymentUnit)) == null) break;
                this._store.setRetiredPackage(retiredProcess, false);
                this._store.setRetiredPackage(retiredProcess, true);
                break;
            }
            default: {
                LOG.debug((Object)("Ignoring store event: " + pse));
            }
        }
        if (pconf != null) {
            if (pse.type == ProcessStoreEvent.Type.UNDEPLOYED) {
                LOG.debug((Object)("Cancelling all cron scheduled jobs on store event: " + pse));
                this._bpelServer.getContexts().cronScheduler.cancelProcessCronJobs(pse.pid, true);
            }
            LOG.debug((Object)("(Re)scheduling cron scheduled jobs on store event: " + pse));
            if (pse.type != ProcessStoreEvent.Type.UNDEPLOYED) {
                this._bpelServer.getContexts().cronScheduler.scheduleProcessCronJobs(pse.pid, pconf);
            }
        }
    }

    @Override
    public Element invoke(QName serviceName, String portName, String operationName, Element mesg, Map<String, Object> headers) throws Exception {
        Element ret = null;
        boolean success = true;
        MyRoleMessageExchange odeMex = null;
        Future responseFuture = null;
        Transaction current = null;
        boolean immediate = this._odeConfig.getProperty("invoke.immediate", Boolean.FALSE.toString()).equalsIgnoreCase(Boolean.TRUE.toString());
        try {
            current = this._txMgr.getTransaction();
            if (current == null) {
                this._txMgr.begin();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Starting transaction.");
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Using existing transaction.");
                }
                immediate = true;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Immediate invocation mode: " + immediate));
            }
            odeMex.setProperty("isTwoWay", Boolean.toString((odeMex = this.createMessageExchange(serviceName, portName, operationName)).getOperation().getOutput() != null));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Is two way operation? " + odeMex.getProperty("isTwoWay")));
            }
            if (odeMex.getOperation() != null) {
                Message odeRequest = odeMex.createMessage(odeMex.getOperation().getInput().getMessage().getQName());
                odeRequest.setMessage(mesg);
                if (headers != null) {
                    Set<String> keys = headers.keySet();
                    for (String key : keys) {
                        Object headerPart = headers.get(key);
                        if (!(headerPart instanceof Element)) continue;
                        Element element = (Element)headerPart;
                        QName name = QName.valueOf(key);
                        odeRequest.setHeaderPart(name.getLocalPart(), element);
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Invoking ODE using MEX " + odeMex));
                    LOG.debug((Object)("Message content:  " + DOMUtils.domToString((Node)odeRequest.getMessage())));
                }
                responseFuture = odeMex.invoke(odeRequest, immediate);
                LOG.debug((Object)("Commiting ODE MEX " + odeMex));
                if (current == null) {
                    try {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Commiting transaction.");
                        }
                        this._txMgr.commit();
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Commit failed", (Throwable)e);
                        success = false;
                    }
                }
            } else {
                success = false;
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Exception occured while invoking ODE", (Throwable)e);
            success = false;
            String errmesg = e.getMessage();
            if (errmesg == null) {
                errmesg = "An exception occured while invoking ODE.";
            }
            throw new Exception(errmesg, e);
        }
        finally {
            if (!success) {
                if (odeMex != null) {
                    odeMex.release(success);
                }
                if (current == null) {
                    try {
                        this._txMgr.rollback();
                    }
                    catch (Exception e) {
                        throw new Exception("Rollback failed", e);
                    }
                }
            }
        }
        if (odeMex.getOperation().getOutput() != null) {
            if (!immediate) {
                try {
                    responseFuture.get(this.resolveTimeout(serviceName, portName, odeMex), TimeUnit.MILLISECONDS);
                }
                catch (Exception e) {
                    String errorMsg = "Timeout or execution error when waiting for response to MEX " + odeMex + " " + e.toString();
                    LOG.error((Object)errorMsg, (Throwable)e);
                    throw new Exception(errorMsg);
                }
            }
            LOG.debug((Object)("Handling response for MEX " + odeMex));
            boolean commit = false;
            if (current == null) {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Starting transaction.");
                    }
                    this._txMgr.begin();
                }
                catch (Exception ex) {
                    throw new Exception("Error starting transaction!", ex);
                }
            }
            try {
                odeMex = (MyRoleMessageExchange)this._bpelServer.getEngine().getMessageExchange(odeMex.getMessageExchangeId());
                Message msg = this.onResponse(odeMex);
                if (msg != null) {
                    Map headerParts = msg.getHeaderParts();
                    if (headers != null) {
                        headers.clear();
                        Set keys = headerParts.keySet();
                        for (String key : keys) {
                            Element e = (Element)msg.getHeaderPart(key).getFirstChild();
                            String k = e.getNamespaceURI() == null || e.getNamespaceURI().isEmpty() ? e.getLocalName() : "{" + e.getNamespaceURI() + "}" + e.getLocalName();
                            headers.put(k, e);
                        }
                    }
                    ret = msg.getMessage();
                }
                LOG.debug((Object)("Returning: " + ret));
                commit = true;
            }
            catch (Fault f) {
                commit = true;
                throw f;
            }
            catch (Exception e) {
                LOG.error((Object)("Error processing response for MEX " + odeMex), (Throwable)e);
                throw new Exception("An exception occured when invoking ODE.", e);
            }
            finally {
                odeMex.release(commit);
                if (current == null) {
                    if (commit) {
                        try {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)"Comitting transaction.");
                            }
                            this._txMgr.commit();
                        }
                        catch (Exception e) {
                            throw new Exception("Commit failed!", e);
                        }
                    }
                    try {
                        this._txMgr.rollback();
                    }
                    catch (Exception ex) {
                        throw new Exception("Rollback failed!", ex);
                    }
                }
            }
            if (!success) {
                throw new Exception("Message was either unroutable or timed out!");
            }
        } else {
            odeMex.release(true);
        }
        return ret;
    }

    private MyRoleMessageExchange createMessageExchange(QName serviceName, String portName, String operationName) {
        String messageId = new GUID().toString();
        MyRoleMessageExchange odeMex = this._bpelServer.getEngine().createMessageExchange(messageId, serviceName, operationName);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("ODE routed to operation " + odeMex.getOperation() + " from service " + serviceName));
        }
        return odeMex;
    }

    private Message onResponse(MyRoleMessageExchange mex) throws Exception {
        Message ret = null;
        switch (mex.getStatus()) {
            case FAULT: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Fault response message: " + mex.getFault()));
                }
                throw new Fault(mex.getFault(), mex.getFaultResponse().getMessage());
            }
            case ASYNC: 
            case RESPONSE: {
                ret = mex.getResponse();
                if (!LOG.isDebugEnabled()) break;
                LOG.debug((Object)("Response message " + ret));
                break;
            }
            case FAILURE: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Failure response message: " + mex.getFault()));
                }
                LOG.error((Object)("Failure details: " + mex.getFaultResponse()));
                throw new Exception("Failure response message: " + mex.getFault() + " : " + mex.getFaultExplanation());
            }
            default: {
                throw new Exception("Received ODE message exchange in unexpected state: " + mex.getStatus());
            }
        }
        return ret;
    }

    private long resolveTimeout(QName serviceName, String portName, MyRoleMessageExchange odeMex) {
        block3: {
            ProcessConf conf = odeMex.getProcessConf();
            String timeout = (String)conf.getEndpointProperties(serviceName, portName).get("mex.timeout");
            if (timeout != null) {
                try {
                    return Long.parseLong(timeout);
                }
                catch (NumberFormatException e) {
                    if (!LOG.isWarnEnabled()) break block3;
                    LOG.warn((Object)("Mal-formatted Property: [mex.timeout=" + timeout + "] Default value (" + 120000 + ") will be used"));
                }
            }
        }
        return 120000L;
    }

    @Override
    public BpelManagementFacade getManagementInterface() {
        return new BpelManagementFacadeImpl((BpelServer)this._bpelServer, (ProcessStore)this._store);
    }

    public RiftSawProcessStore getStore() {
        return this._store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(BPELEngineListener l) {
        Map<BPELEngineListener, ProxyBpelEventListener> map = this._listeners;
        synchronized (map) {
            if (!this._listeners.containsKey(l)) {
                ProxyBpelEventListener bel = new ProxyBpelEventListener(l);
                this._listeners.put(l, bel);
                this._bpelServer.registerBpelEventListener((BpelEventListener)bel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(BPELEngineListener l) {
        Map<BPELEngineListener, ProxyBpelEventListener> map = this._listeners;
        synchronized (map) {
            if (this._listeners.containsKey(l)) {
                ProxyBpelEventListener bel = this._listeners.remove(l);
                this._bpelServer.unregisterBpelEventListener((BpelEventListener)bel);
            }
        }
    }

    protected class ProxyBpelEventListener
    implements BpelEventListener {
        private BPELEngineListener _listener = null;

        public ProxyBpelEventListener(BPELEngineListener l) {
            this._listener = l;
        }

        public void onEvent(BpelEvent bpelEvent) {
            this._listener.onEvent(bpelEvent);
        }

        public void startup(Properties configProperties) {
        }

        public void shutdown() {
        }
    }

    private class ProcessStoreListenerImpl
    implements ProcessStoreListener {
        private ProcessStoreListenerImpl() {
        }

        public void onProcessStoreEvent(ProcessStoreEvent event) {
            BPELEngineImpl.this.handleEvent(event);
        }
    }
}

