/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.bootstrap.ui.blockquote;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.bootstrap.ui.blockquote.AbstractBlockquote;
import org.richfaces.bootstrap.ui.blockquote.BlockquoteRendererBase;

public class BlockquoteRenderer
extends BlockquoteRendererBase {
    private static String convertToString(Object object) {
        return object != null ? object.toString() : "";
    }

    public void doEncodeBegin(ResponseWriter responseWriter, FacesContext facesContext, UIComponent uiComponent) throws IOException {
        AbstractBlockquote component = (AbstractBlockquote)uiComponent;
        String clientId = component.getClientId(facesContext);
        responseWriter.startElement("blockquote", (UIComponent)component);
        String value = component.getCite();
        if (null != value && value.length() > 0) {
            responseWriter.writeURIAttribute("cite", (Object)value, null);
        }
        if (null != (value = BlockquoteRenderer.convertToString(component.getStyleClass()) + " " + BlockquoteRenderer.convertToString(component.getPosition() != null && !component.getPosition().equals("") ? "pull-".concat(component.getPosition()) : "")) && value.length() > 0) {
            responseWriter.writeAttribute("class", (Object)value, null);
        }
        if (null != (value = clientId) && value.length() > 0) {
            responseWriter.writeAttribute("id", (Object)value, null);
        }
        if (null != (value = component.getStyle()) && value.length() > 0) {
            responseWriter.writeAttribute("style", (Object)value, null);
        }
    }

    public void doEncodeEnd(ResponseWriter responseWriter, FacesContext facesContext, UIComponent uiComponent) throws IOException {
        AbstractBlockquote component = (AbstractBlockquote)uiComponent;
        String clientId = component.getClientId(facesContext);
        if (component.getAuthor() != null && !component.getAuthor().equals("")) {
            responseWriter.startElement("small", (UIComponent)component);
            if (component.getCite() != null && !component.getCite().equals("")) {
                String text;
                responseWriter.startElement("cite", (UIComponent)component);
                String value = component.getCite();
                if (null != value && value.length() > 0) {
                    responseWriter.writeAttribute("title", (Object)value, null);
                }
                if ((text = component.getAuthor()) != null) {
                    responseWriter.writeText((Object)text, null);
                }
                responseWriter.endElement("cite");
            } else {
                String text = component.getAuthor();
                if (text != null) {
                    responseWriter.writeText((Object)text, null);
                }
            }
            responseWriter.endElement("small");
        }
        responseWriter.endElement("blockquote");
    }
}

