/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.bootstrap.less;

import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.ResponseWriter;
import javax.faces.context.ResponseWriterWrapper;

public class LessResponseWriter
extends ResponseWriterWrapper {
    private ResponseWriter wrapped;
    private boolean insideLink = false;
    private LessStylesheetDetector detector;

    public LessResponseWriter(ResponseWriter wrapped) {
        this.wrapped = wrapped;
    }

    public ResponseWriter cloneWithWriter(Writer writer) {
        return new LessResponseWriter(super.cloneWithWriter(writer));
    }

    public void startElement(String name, UIComponent component) throws IOException {
        super.startElement(name, component);
        if ("link".equals(name)) {
            this.insideLink = true;
            this.detector = new LessStylesheetDetector();
        } else {
            this.insideLink = false;
        }
    }

    private void writeAttributesFinally(ResponseWriter writer) throws IOException {
        if (this.insideLink) {
            this.detector.writeAttributes(writer);
        }
    }

    public void endElement(String name) throws IOException {
        this.writeAttributesFinally(this.wrapped);
        super.endElement(name);
        if ("link".equals(name)) {
            this.insideLink = false;
        }
    }

    public void writeAttribute(String name, Object value, String property) throws IOException {
        if (this.insideLink) {
            this.detector.putAttribute(name, value, property);
        } else {
            super.writeAttribute(name, value, property);
        }
    }

    public void writeURIAttribute(String name, Object value, String property) throws IOException {
        if (this.insideLink) {
            this.detector.putURIAttribute(name, value, property);
        } else {
            super.writeURIAttribute(name, value, property);
        }
    }

    public ResponseWriter getWrapped() {
        return this.wrapped;
    }

    public void writeText(char[] text, int off, int len) throws IOException {
        this.writeAttributesFinally(this.wrapped);
        super.writeText(text, off, len);
    }

    public void writeText(Object text, String property) throws IOException {
        this.writeAttributesFinally(this.wrapped);
        super.writeText(text, property);
    }

    public void writeText(Object text, UIComponent component, String property) throws IOException {
        this.writeAttributesFinally(this.wrapped);
        super.writeText(text, component, property);
    }

    public void writeComment(Object comment) throws IOException {
        this.writeAttributesFinally(this.wrapped);
        super.writeComment(comment);
    }

    private static class LessStylesheetDetector {
        private Map<String, ValuePropertyPair> attributes = new LinkedHashMap<String, ValuePropertyPair>();

        private LessStylesheetDetector() {
        }

        private void putAttribute(String name, Object value, String property) {
            ValuePropertyPair pair = new ValuePropertyPair(property, value, false);
            this.attributes.put(name, pair);
        }

        private void putURIAttribute(String name, Object value, String property) {
            ValuePropertyPair pair = new ValuePropertyPair(property, value, true);
            this.attributes.put(name, pair);
        }

        private boolean isLessStylesheet() {
            ValuePropertyPair typePair = this.attributes.get("type");
            ValuePropertyPair relPair = this.attributes.get("rel");
            ValuePropertyPair hrefPair = this.attributes.get("href");
            if (typePair == null || relPair == null || hrefPair == null) {
                return false;
            }
            return typePair.valueMatches("text/css") && relPair.valueMatches("stylesheet") && hrefPair.valueContains(".less");
        }

        private void writeAttributes(ResponseWriter writer) throws IOException {
            boolean isStylesheet = this.isLessStylesheet();
            for (Map.Entry<String, ValuePropertyPair> attribute : this.attributes.entrySet()) {
                String name = attribute.getKey();
                ValuePropertyPair pair = attribute.getValue();
                Object value = pair.getValue();
                String property = pair.getProperty();
                boolean isUri = pair.isUri();
                if ("rel".equals(name) && !isUri && isStylesheet) {
                    writer.writeAttribute(name, (Object)"stylesheet/less", property);
                    continue;
                }
                if (isUri) {
                    writer.writeURIAttribute(name, value, property);
                    continue;
                }
                writer.writeAttribute(name, value, property);
            }
        }

        private class ValuePropertyPair {
            private String property;
            private Object value;
            private boolean isUri;

            public ValuePropertyPair(String property, Object value, boolean isUri) {
                this.property = property;
                this.value = value;
                this.isUri = isUri;
            }

            public String getProperty() {
                return this.property;
            }

            public Object getValue() {
                return this.value;
            }

            public boolean isUri() {
                return this.isUri;
            }

            public boolean valueMatches(String expected) {
                if (this.value == null) {
                    return false;
                }
                return this.value.toString().equals(expected);
            }

            public boolean valueContains(String expected) {
                if (this.value == null) {
                    return false;
                }
                return this.value.toString().contains(expected);
            }
        }
    }
}

