/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import javax.faces.context.FacesContext;
import org.ajax4jsf.resource.Java2Dresource;
import org.ajax4jsf.util.HtmlColor;
import org.ajax4jsf.util.NumericDataInputStream;
import org.ajax4jsf.util.NumericDataOutputStream;
import org.richfaces.VersionBean;
import org.richfaces.resource.ResourceUtils;
import org.richfaces.skin.Skin;
import org.richfaces.skin.SkinFactory;

public class TestResource2
extends Java2Dresource {
    protected Color color;
    protected Dimension dimension = new Dimension(20, 150);

    public TestResource2() {
        super(Java2Dresource.ImageType.PNG);
        FacesContext context = FacesContext.getCurrentInstance();
        Skin skin = SkinFactory.getInstance().getSkin(context);
        Object parameter = skin.getParameter(context, "headerGradientColor");
        this.color = HtmlColor.decode(parameter.toString());
    }

    protected void paint(Graphics2D graphics2d, Dimension dim) {
        super.paint(graphics2d, dim);
        graphics2d.setPaint(new GradientPaint(0.0f, 0.0f, Color.WHITE, dim.width, dim.height, this.color));
        graphics2d.fillRect(0, 0, dim.width, dim.height);
    }

    protected void readState(FacesContext context, NumericDataInputStream stream) {
        super.readState(context, stream);
        this.color = stream.readColor();
    }

    protected void writeState(FacesContext context, NumericDataOutputStream stream) {
        super.writeState(context, stream);
        stream.writeColor(this.color);
    }

    public String getEntityTag(FacesContext context) {
        return ResourceUtils.formatWeakTag(Integer.toHexString(this.color.getRGB() & 0xFFFFFF));
    }

    public String getVersion() {
        return VersionBean._version.getResourceVersion();
    }

    public Dimension getDimension() {
        return this.dimension;
    }
}

