/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialViewContext;
import javax.faces.context.PartialViewContextWrapper;
import javax.faces.event.PhaseId;
import org.ajax4jsf.component.AjaxClientBehavior;
import org.ajax4jsf.component.AjaxOutput;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.ajax4jsf.renderkit.RendererUtils;
import org.richfaces.context.PartialViewContextAjaxOutputTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartialViewContextImpl
extends PartialViewContextWrapper {
    public static final String BEHAVIOR_EVENT_PARAMETER = "javax.faces.behavior.event";
    private final PartialViewContext wrappedContext;
    private final String activatorId;
    private boolean hasProcessedExecute = false;
    private boolean executeAll = true;
    private String behaviorEvent = null;

    public PartialViewContextImpl(PartialViewContext wrappedContext, String activatorId) {
        this.wrappedContext = wrappedContext;
        this.activatorId = activatorId;
    }

    public PartialViewContext getWrapped() {
        return this.wrappedContext;
    }

    private VisitContext createVisitContext(FacesContext facesContext) {
        return VisitContext.createVisitContext((FacesContext)facesContext, Collections.singleton(this.activatorId), Collections.singleton(VisitHint.SKIP_UNRENDERED));
    }

    private Collection<String> getAjaxOutputComponentIds(FacesContext facesContext) {
        ArrayList<String> ids = new ArrayList<String>();
        Collection<AjaxOutput> ajaxOutputComponentsSet = PartialViewContextAjaxOutputTracker.getAjaxOutputComponentsSet(facesContext);
        for (AjaxOutput ajaxOutput : ajaxOutputComponentsSet) {
            if (!ajaxOutput.isAjaxRendered()) continue;
            UIComponent ajaxOutputComponent = (UIComponent)ajaxOutput;
            ids.add(ajaxOutputComponent.getClientId(facesContext));
        }
        return ids;
    }

    private void decodeBehaviorEvent(FacesContext context) {
        Map requestParameterMap = context.getExternalContext().getRequestParameterMap();
        this.behaviorEvent = (String)requestParameterMap.get(BEHAVIOR_EVENT_PARAMETER);
    }

    private void processExecute(PartialViewContext partialViewContext) {
        if (!this.hasProcessedExecute) {
            this.hasProcessedExecute = true;
            FacesContext facesContext = FacesContext.getCurrentInstance();
            this.decodeBehaviorEvent(facesContext);
            ExecuteComponentCallback executeCallback = new ExecuteComponentCallback(this.behaviorEvent);
            boolean visitResult = facesContext.getViewRoot().visitTree(this.createVisitContext(facesContext), (VisitCallback)executeCallback);
            if (!visitResult) {
                // empty if block
            }
            this.executeAll = executeCallback.isHandleAll();
            if (!this.executeAll) {
                Collection executeIds = partialViewContext.getExecuteIds();
                executeIds.clear();
                if (!executeCallback.isHandleNone()) {
                    executeIds.addAll(executeCallback.getComponentIds());
                }
            }
        }
    }

    private void processRender(PartialViewContext partialViewContext) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (!partialViewContext.isRenderAll()) {
            RenderComponentCallback renderCallback = new RenderComponentCallback(this.behaviorEvent);
            boolean visitResult = facesContext.getViewRoot().visitTree(this.createVisitContext(facesContext), (VisitCallback)renderCallback);
            if (!visitResult) {
                // empty if block
            }
            boolean renderAll = renderCallback.isHandleAll();
            partialViewContext.setRenderAll(renderAll);
            if (!renderAll) {
                Collection renderIds = partialViewContext.getRenderIds();
                renderIds.clear();
                if (!renderCallback.isHandleNone()) {
                    renderIds.addAll(renderCallback.getComponentIds());
                    if (!renderCallback.isLimitRender()) {
                        Collection<String> ajaxOutputComponentIds = this.getAjaxOutputComponentIds(facesContext);
                        renderIds.addAll(ajaxOutputComponentIds);
                    }
                }
            }
        }
    }

    public void processPartial(PhaseId phaseId) {
        PartialViewContext wrapped = this.getWrapped();
        if (PhaseId.APPLY_REQUEST_VALUES.equals(phaseId)) {
            this.processExecute(wrapped);
        } else if (PhaseId.RENDER_RESPONSE.equals(phaseId)) {
            this.processRender(wrapped);
        }
        wrapped.processPartial(phaseId);
    }

    public void setPartialRequest(boolean isPartialRequest) {
        this.getWrapped().setPartialRequest(isPartialRequest);
    }

    public Collection<String> getRenderIds() {
        return this.getWrapped().getRenderIds();
    }

    public Collection<String> getExecuteIds() {
        return this.getWrapped().getExecuteIds();
    }

    public boolean isExecuteAll() {
        this.processExecute(this.getWrapped());
        return this.executeAll;
    }

    public boolean isRenderAll() {
        return this.getWrapped().isRenderAll();
    }

    private static class RenderComponentCallback
    extends ComponentCallback {
        private boolean limitRender = false;

        public RenderComponentCallback(String behaviorEvent) {
            super(behaviorEvent, false, false);
        }

        public boolean isLimitRender() {
            return this.limitRender;
        }

        protected void doVisit(FacesContext context, UIComponent target, AjaxClientBehavior behavior) {
            super.doVisit(context, target, behavior);
            this.limitRender = AjaxRendererUtils.isAjaxLimitRender(target);
            if (behavior != null) {
                this.limitRender = behavior.isLimitRender();
            }
        }

        public Object getAttributeValue(UIComponent component) {
            return component.getAttributes().get("render");
        }

        protected Object getBehaviorAttributeValue(AjaxClientBehavior behavior) {
            return behavior.getRender();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExecuteComponentCallback
    extends ComponentCallback {
        public ExecuteComponentCallback(String behaviorEvent) {
            super(behaviorEvent, false, true);
        }

        @Override
        protected void addDefaultComponents(Collection<String> ids) {
            super.addDefaultComponents(ids);
            ids.add("@this");
        }

        @Override
        public Object getAttributeValue(UIComponent component) {
            return component.getAttributes().get("execute");
        }

        @Override
        protected Object getBehaviorAttributeValue(AjaxClientBehavior behavior) {
            return behavior.getExecute();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class ComponentCallback
    implements VisitCallback {
        private final String behaviorEvent;
        private boolean handleAll;
        private boolean handleNone;
        private Collection<String> componentIds = new LinkedHashSet<String>();

        public ComponentCallback(String behaviorEvent, boolean handleNone, boolean handleAll) {
            this.behaviorEvent = behaviorEvent;
            this.handleNone = handleNone;
            this.handleAll = handleAll;
        }

        protected void addDefaultComponents(Collection<String> ids) {
        }

        private AjaxClientBehavior findBehavior(UIComponent target) {
            ClientBehaviorHolder behaviorHolder;
            List behaviors;
            AjaxClientBehavior result = null;
            if (this.behaviorEvent != null && target instanceof ClientBehaviorHolder && (behaviors = (List)(behaviorHolder = (ClientBehaviorHolder)target).getClientBehaviors().get(this.behaviorEvent)) != null) {
                for (ClientBehavior behavior : behaviors) {
                    AjaxClientBehavior ajaxBehavior;
                    if (!(behavior instanceof AjaxClientBehavior) || (ajaxBehavior = (AjaxClientBehavior)behavior).isDisabled()) continue;
                    result = (AjaxClientBehavior)behavior;
                    break;
                }
            }
            if (result == null) {
                // empty if block
            }
            return result;
        }

        protected abstract Object getBehaviorAttributeValue(AjaxClientBehavior var1);

        protected abstract Object getAttributeValue(UIComponent var1);

        protected void doVisit(FacesContext context, UIComponent target, AjaxClientBehavior behavior) {
            Object attributeObject = null;
            attributeObject = behavior != null ? this.getBehaviorAttributeValue(behavior) : this.getAttributeValue(target);
            Set<String> attributeIds = AjaxRendererUtils.asSet(attributeObject);
            if (attributeIds != null && !attributeIds.isEmpty()) {
                if (attributeIds.contains("@all")) {
                    if (!((Object)AjaxRendererUtils.ALL_SET).equals(attributeIds)) {
                        // empty if block
                    }
                    this.handleAll = true;
                } else {
                    this.handleAll = false;
                    if (attributeIds.contains("@none")) {
                        if (!((Object)AjaxRendererUtils.NONE_SET).equals(attributeIds)) {
                            // empty if block
                        }
                        this.handleNone = true;
                    } else {
                        this.addDefaultComponents(attributeIds);
                        this.componentIds.addAll(RendererUtils.getInstance().findComponentsFor(context, target, attributeIds));
                    }
                }
            }
        }

        public final VisitResult visit(VisitContext visitContext, UIComponent target) {
            AjaxClientBehavior ajaxBehavior = null;
            if (this.behaviorEvent != null) {
                ajaxBehavior = this.findBehavior(target);
            }
            this.doVisit(visitContext.getFacesContext(), target, ajaxBehavior);
            return VisitResult.COMPLETE;
        }

        public Collection<String> getComponentIds() {
            return this.componentIds;
        }

        public boolean isHandleAll() {
            return this.handleAll;
        }

        public boolean isHandleNone() {
            return this.handleNone;
        }
    }
}

