/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.resource;

import java.io.IOException;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.ajax4jsf.Messages;
import org.ajax4jsf.resource.BaseResourceRenderer;
import org.ajax4jsf.resource.InternetResource;
import org.richfaces.log.RichfacesLogger;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OneTimeRenderer
extends BaseResourceRenderer {
    private static final Logger log = RichfacesLogger.RESOURCE.getLogger();

    @Override
    public void encodeBegin(InternetResource resource, FacesContext context, Object data, Map<String, Object> attributes) throws IOException {
        if (!this.isRendered(resource, context)) {
            super.encodeBegin(resource, context, data, attributes);
        } else if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage((String)"SKIP_ENCODE_BEGIN_HTML_INFO_2", (Object)resource.getKey()));
        }
    }

    @Override
    public void encodeEnd(InternetResource resource, FacesContext context, Object data) throws IOException {
        if (!this.isRendered(resource, context)) {
            super.encodeEnd(resource, context, data);
            context.getExternalContext().getRequestMap().put(resource.getKey(), Boolean.TRUE);
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage((String)"MARK_AS_RENDERED_INFO", (Object)resource.getKey()));
            }
        } else if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage((String)"SKIP_ENCODE_END_HTML_INFO_2", (Object)resource.getKey()));
        }
    }

    private boolean isRendered(InternetResource resource, FacesContext context) {
        return null != context.getExternalContext().getRequestMap().get(resource.getKey());
    }
}

