/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.cache;

import java.util.Date;
import java.util.PriorityQueue;
import org.ajax4jsf.cache.Cache;
import org.ajax4jsf.util.LRUMap;

public class LRUMapCache
implements Cache {
    private CacheMap map;

    public LRUMapCache() {
        this.map = new CacheMap();
    }

    public LRUMapCache(int capacity) {
        this.map = new CacheMap(capacity);
    }

    public synchronized Object get(Object key) {
        this.map.purge();
        CacheEntry entry = (CacheEntry)this.map.get(key);
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    public synchronized void put(Object key, Object value, Date expired) {
        this.map.purge();
        CacheEntry cacheEntry = new CacheEntry(key, value, expired);
        this.map.put(key, cacheEntry);
    }

    public void start() {
    }

    public void stop() {
        this.map.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class CacheEntry
    implements Comparable<CacheEntry> {
        private Object key;
        private Object value;
        private Date expired;

        public CacheEntry(Object key, Object value, Date expired) {
            this.key = key;
            this.value = value;
            this.expired = expired;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean isExpired() {
            if (this.expired != null) {
                return System.currentTimeMillis() >= this.expired.getTime();
            }
            return false;
        }

        @Override
        public int compareTo(CacheEntry o) {
            int result = this.expired.compareTo(o.expired);
            if (result == 0) {
                result = this.key.toString().compareTo(o.key.toString());
            }
            return result;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheEntry other = (CacheEntry)obj;
            return !(this.key == null ? other.key != null : !this.key.equals(other.key));
        }

        public String toString() {
            if (this.expired == null) {
                return this.key.toString();
            }
            return this.key + ": " + this.expired;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class CacheMap
    extends LRUMap<Object, CacheEntry> {
        private static final long serialVersionUID = -5422668357346537621L;
        protected PriorityQueue<CacheEntry> expirationQueue = new PriorityQueue();

        public CacheMap() {
        }

        public CacheMap(int capacity) {
            super(capacity);
        }

        @Override
        public CacheEntry put(Object key, CacheEntry value) {
            CacheEntry entry = super.put(key, value);
            if (entry != null) {
                this.expirationQueue.remove(entry);
            }
            if (value.expired != null) {
                this.expirationQueue.add(value);
            }
            return entry;
        }

        @Override
        public CacheEntry remove(Object key) {
            CacheEntry entry = (CacheEntry)super.remove(key);
            if (entry != null) {
                this.expirationQueue.remove(entry);
            }
            return entry;
        }

        @Override
        public void clear() {
            super.clear();
            this.expirationQueue.clear();
        }

        public void purge() {
            CacheEntry queueEntry = null;
            while ((queueEntry = this.expirationQueue.peek()) != null && queueEntry.isExpired()) {
                super.remove(queueEntry.getKey());
                this.expirationQueue.remove();
            }
        }
    }
}

