/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.ajax4jsf.util.HtmlDimensions;

public class HtmlUtil {
    public static final Pattern idSelectorPattern = Pattern.compile("#((:|_|[a-z,A-Z])[a-z,A-Z,0-9,_,-,:]+)");

    public static String qualifySize(String sizeDeclaration) {
        char lastChar;
        String trimmedValue = sizeDeclaration.trim();
        if (trimmedValue.length() != 0 && Character.isDigit(lastChar = trimmedValue.charAt(trimmedValue.length() - 1))) {
            return sizeDeclaration + "px";
        }
        return sizeDeclaration;
    }

    public static String addToSize(String declaration, String delta) {
        Double doubleDelta = HtmlDimensions.decode(delta);
        Double decoded = HtmlDimensions.decode(declaration);
        return HtmlDimensions.formatPx(new Double(decoded + doubleDelta));
    }

    public static String expandIdSelector(String selector, UIComponent component, FacesContext context) {
        Matcher matcher = idSelectorPattern.matcher(selector);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            UIComponent target;
            if (matcher.group(1).indexOf("::") != -1 || (target = component.findComponent(matcher.group(1))) == null) continue;
            matcher.appendReplacement(sb, "#" + target.getClientId(context).replaceAll(":", "\\\\\\\\\\\\\\\\:"));
        }
        matcher.appendTail(sb);
        String result = sb.toString();
        if (result.length() == 0) {
            result = selector;
        }
        return sb.toString();
    }
}

