/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.model;

import javax.swing.tree.TreeNode;
import org.richfaces.model.CacheableSwingTreeNodeImpl;
import org.richfaces.model.CacheableTreeDataModel;
import org.richfaces.model.SwingTreeNodeImpl;
import org.richfaces.model.TreeDataModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwingCacheableTreeDataModel
extends CacheableTreeDataModel<TreeNode> {
    private static final TreeDataModel.MissingNodeHandler<TreeNode> missingNodeHandler = new TreeDataModel.MissingNodeHandler<TreeNode>(){

        @Override
        public TreeNode handleMissingNode(TreeNode parent, Object pathSegment) {
            CacheableSwingTreeNodeImpl childNode = new CacheableSwingTreeNodeImpl();
            if (parent != null) {
                SwingTreeNodeImpl parentNode = (SwingTreeNodeImpl)parent;
                parentNode.addChild(pathSegment, childNode);
                childNode.setParent(parentNode);
            }
            return childNode;
        }
    };

    public SwingCacheableTreeDataModel(TreeDataModel<TreeNode> model) {
        super(model, missingNodeHandler);
    }

    @Override
    public Object getRowData() {
        SwingTreeNodeImpl swingTreeNodeImpl = (SwingTreeNodeImpl)super.getRowData();
        if (swingTreeNodeImpl != null) {
            return swingTreeNodeImpl.getData();
        }
        return null;
    }

    @Override
    protected void setDefaultNodeData(TreeNode node, Object data) {
        CacheableSwingTreeNodeImpl cacheableTreeNode = (CacheableSwingTreeNodeImpl)node;
        cacheableTreeNode.setData(data);
        cacheableTreeNode.setNotLeaf(!this.isLeaf());
    }
}

