/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.swing.tree.TreeNode;
import org.richfaces.model.ListRowKey;
import org.richfaces.model.SwingTreeNodeImpl;
import org.richfaces.model.TreeDataModel;
import org.richfaces.model.TreeDataModelNodeAdaptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwingTreeDataModel
extends TreeDataModel<TreeNode> {
    private TreeNode treeNode;

    public SwingTreeDataModel() {
        super(TreeNode.class, TreeDataModelNodeAdaptor.swingTreeNodeAdaptor, null);
    }

    @Override
    protected TreeNode getData() {
        return this.treeNode;
    }

    @Override
    public void setWrappedData(Object data) {
        if (data != null) {
            SwingTreeNodeImpl treeNodeImpl = new SwingTreeNodeImpl();
            int counter = 0;
            if (data instanceof Collection) {
                Collection collection = (Collection)data;
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    treeNodeImpl.addChild(counter++, (TreeNode)iterator.next());
                }
            } else if (data.getClass().isArray()) {
                Object[] nodes = (Object[])data;
                for (int i = 0; i < nodes.length; ++i) {
                    treeNodeImpl.addChild(counter++, (TreeNode)nodes[i]);
                }
            } else {
                treeNodeImpl.addChild(counter++, (TreeNode)data);
            }
            this.treeNode = treeNodeImpl;
        } else {
            this.treeNode = null;
        }
        super.setWrappedData(data);
    }

    @Override
    public Object convertToKey(FacesContext context, String keyString, UIComponent component, Converter converter) {
        String[] strings = ListRowKey.fromString(keyString);
        ArrayList<Integer> list = new ArrayList<Integer>(strings.length);
        TreeNode node = this.treeNode;
        if (node != null) {
            TreeDataModelNodeAdaptor<TreeNode> adaptor = this.getNodeAdaptor();
            for (int i = 0; i < strings.length; ++i) {
                int key = Integer.parseInt(strings[i]);
                if ((node = adaptor.getChild(node, key)) == null) {
                    return null;
                }
                list.add(key);
            }
        }
        return new ListRowKey(list);
    }
}

