/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.model;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import org.ajax4jsf.model.DataVisitor;
import org.ajax4jsf.model.Range;
import org.richfaces.model.LastElementAware;
import org.richfaces.model.TreeDataModel;
import org.richfaces.model.TreeRange;
import org.richfaces.model.TreeRowKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CacheableTreeDataModel<T>
extends TreeDataModel<T> {
    private static final DataVisitor NULL_VISITOR = new DataVisitor(){

        public void process(FacesContext context, Object rowKey, Object argument) throws IOException {
        }
    };
    private TreeDataModel<T> treeDataModel;

    @Override
    public boolean isLeaf() {
        TreeRowKey rowKey = (TreeRowKey)this.getRowKey();
        Object treeNode = this.locateTreeNode(rowKey);
        if (treeNode != null && !this.nodeAdaptor.isLeaf(treeNode)) {
            return false;
        }
        treeNode = this.treeDataModel.locateTreeNode(rowKey);
        if (treeNode != null) {
            return this.nodeAdaptor.isLeaf(treeNode);
        }
        return false;
    }

    public CacheableTreeDataModel(TreeDataModel<T> model, TreeDataModel.MissingNodeHandler<T> missingNodeHandler) {
        super(model.getClazz(), model.getNodeAdaptor(), missingNodeHandler);
        this.setWrappedData(missingNodeHandler.handleMissingNode(null, null));
        this.setTreeDataModel(model);
    }

    @Override
    public void walkModel(FacesContext context, DataVisitor visitor, Range range, Object key, Object argument, boolean last) throws IOException {
        this.treeDataModel.walkModel(context, new Visitor(visitor), range, key, argument, last);
    }

    public void setTreeDataModel(TreeDataModel<T> treeDataModel) {
        this.treeDataModel = treeDataModel;
    }

    public TreeDataModel<T> getTreeDataModel() {
        return this.treeDataModel;
    }

    @Override
    public void walk(FacesContext context, DataVisitor dataVisitor, Range range, Object rowKey, Object argument, boolean last) throws IOException {
        Object cachedTreeNode = this.locateTreeNode((TreeRowKey)rowKey);
        T treeNode = this.treeDataModel.locateTreeNode((TreeRowKey)rowKey);
        if (treeNode != null) {
            if (cachedTreeNode == null || this.nodeAdaptor.isLeaf(cachedTreeNode) && !this.nodeAdaptor.isLeaf(treeNode)) {
                this.treeDataModel.walk(context, new Visitor(dataVisitor), range, rowKey, argument, last);
            } else {
                super.walk(context, dataVisitor, range, rowKey, argument, last);
            }
        }
    }

    public void setTransient(boolean newTransientValue) {
        if (!newTransientValue) {
            throw new IllegalArgumentException("ReplaceableTreeDataModel shouldn't be transient!");
        }
    }

    protected abstract void setDefaultNodeData(T var1, Object var2);

    @Override
    public Object convertToKey(FacesContext context, String keyString, UIComponent component, Converter converter) {
        Object convertedKey = this.treeDataModel.convertToKey(context, keyString, component, converter);
        if (convertedKey != null) {
            final TreeRowKey treeRowKey = (TreeRowKey)convertedKey;
            try {
                this.walk(context, NULL_VISITOR, new TreeRange(){

                    public boolean processChildren(TreeRowKey rowKey) {
                        return rowKey == null || rowKey.isSubKey(treeRowKey);
                    }

                    public boolean processNode(TreeRowKey rowKey) {
                        return this.processChildren(rowKey) || rowKey.equals(treeRowKey);
                    }
                }, null);
            }
            catch (IOException e) {
                context.getExternalContext().log(e.getLocalizedMessage(), (Throwable)e);
                return null;
            }
        }
        return convertedKey;
    }

    private final class Visitor
    implements DataVisitor,
    LastElementAware {
        private final DataVisitor visitor;

        private Visitor(DataVisitor visitor) {
            this.visitor = visitor;
        }

        public void process(FacesContext context, Object rowKey, Object argument) throws IOException {
            TreeRowKey treeRowKey = (TreeRowKey)rowKey;
            CacheableTreeDataModel.this.treeDataModel.setRowKey(treeRowKey);
            CacheableTreeDataModel.this.setDefaultNodeData(CacheableTreeDataModel.this.locateTreeNode(treeRowKey, true), CacheableTreeDataModel.this.treeDataModel.getRowData());
            if (this.visitor != null) {
                this.visitor.process(context, rowKey, argument);
            }
        }

        public void resetLastElement() {
            if (this.visitor instanceof LastElementAware) {
                ((LastElementAware)((Object)this.visitor)).resetLastElement();
            }
        }

        public void setLastElement() {
            if (this.visitor instanceof LastElementAware) {
                ((LastElementAware)((Object)this.visitor)).setLastElement();
            }
        }
    }
}

