/**
 * 
 */
package org.richfaces.model;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

import javax.faces.context.FacesContext;

import org.ajax4jsf.model.DataVisitor;
import org.ajax4jsf.model.ExtendedDataModel;
import org.ajax4jsf.model.Range;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/**
 * That is intended for internal use
 * 
 * @author Nick Belaevski mailto:nbelaevski@exadel.com created 30.07.2007
 */
public class MapDataModel extends ExtendedDataModel {

	private Map map;
	private Object rowKey;
	private Object wrappedData;
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.ajax4jsf.model.ExtendedDataModel#getRowKey()
	 */
	public Object getRowKey() {
		return rowKey;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.ajax4jsf.model.ExtendedDataModel#setRowKey(java.lang.Object)
	 */

	public void setRowKey(Object key) {
		this.rowKey = key;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.ajax4jsf.model.ExtendedDataModel#walk(javax.faces.context.FacesContext,
	 *      org.ajax4jsf.model.DataVisitor, org.ajax4jsf.model.Range,
	 *      java.lang.Object)
	 */

	public void walk(FacesContext context, DataVisitor visitor, Range range,
			Object argument) throws IOException {
		if (map != null) {
			for (Iterator iterator = map.keySet().iterator(); iterator.hasNext();) {
				Object key = (Object) iterator.next();
				
				visitor.process(context, key, argument);
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.faces.model.DataModel#getRowCount()
	 */

	public int getRowCount() {
		return map != null ? map.size() : 0;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.faces.model.DataModel#getRowData()
	 */

	public Object getRowData() {
		return map != null ? map.get(rowKey) : null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.faces.model.DataModel#getRowIndex()
	 */

	public int getRowIndex() {
		return 0;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.faces.model.DataModel#getWrappedData()
	 */
	public Object getWrappedData() {
		return wrappedData;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.faces.model.DataModel#isRowAvailable()
	 */
	public boolean isRowAvailable() {
		return map != null && map.containsKey(rowKey);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.faces.model.DataModel#setRowIndex(int)
	 */
	public void setRowIndex(int rowIndex) {
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.faces.model.DataModel#setWrappedData(java.lang.Object)
	 */
	public void setWrappedData(Object data) {
		this.wrappedData = data;
		if (data instanceof NamedNodeMap) {
			this.map = new AbstractMap() {

				private Set entrySet = new AbstractSet() {

					public Iterator iterator() {
						return new Iterator() {
							private int index = 0;

							public boolean hasNext() {
								return index < ((NamedNodeMap) getWrappedData()).getLength();
							}

							public Object next() {
								final Node node = ((NamedNodeMap) getWrappedData()).item(index++);
								if (node == null) {
									throw new NoSuchElementException();
								} else {
									return new Map.Entry() {

										public Object getKey() {
											return node.getNodeName();
										}

										public Object getValue() {
											return node;
										}

										public Object setValue(Object arg0) {
											throw new UnsupportedOperationException();
										}
										
									};
								}
							}

							public void remove() {
								throw new UnsupportedOperationException();
							}
						};
					}

					public int size() {
						return ((NamedNodeMap) getWrappedData()).getLength();
					}
					
				};
				
				public boolean containsKey(Object key) {
					return ((NamedNodeMap) getWrappedData()).getNamedItem((String) key) != null;
				}
				
				public Object get(Object key) {
					return ((NamedNodeMap) getWrappedData()).getNamedItem((String) key);
				}
				
				public Set entrySet() {
					return entrySet;
				}
				
			};
		} else if (data != null) {
			this.map = (Map) data;
		} else {
			this.map = null;
		}
	}

}
