/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.netbeans.lib.cvsclient.util.Logger;

public class LoggedDataOutputStream
extends FilterOutputStream {
    private long counter;

    public LoggedDataOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public void writeChars(String string) throws IOException {
        this.writeBytes(string);
    }

    public void writeBytes(String string) throws IOException {
        byte[] byArray = string.getBytes();
        this.out.write(byArray);
        Logger.logOutput(byArray);
        this.counter += (long)byArray.length;
    }

    public void writeBytes(String string, String string2) throws IOException {
        byte[] byArray = string.getBytes(string2);
        this.out.write(byArray);
        Logger.logOutput(byArray);
        this.counter += (long)byArray.length;
    }

    public void write(int n) throws IOException {
        super.write(n);
        ++this.counter;
    }

    public void write(byte[] byArray) throws IOException {
        super.write(byArray);
        this.counter += (long)byArray.length;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        super.write(byArray, n, n2);
        this.counter += (long)n2;
    }

    public void close() throws IOException {
        this.out.close();
    }

    public OutputStream getUnderlyingStream() {
        return this.out;
    }

    public void setUnderlyingStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    public long getCounter() {
        return this.counter;
    }
}

