/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.event;

import java.io.File;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.event.CVSEvent;
import org.netbeans.lib.cvsclient.event.CVSListener;
import org.netbeans.lib.cvsclient.event.FileInfoEvent;

public class EventManager {
    private CVSListener[] listeners;
    private boolean fireEnhancedEventSet = true;
    private final ClientServices services;

    public EventManager(ClientServices clientServices) {
        this.services = clientServices;
    }

    public ClientServices getClientServices() {
        return this.services;
    }

    public synchronized void addCVSListener(CVSListener cVSListener) {
        if (this.listeners == null || this.listeners.length == 0) {
            this.listeners = new CVSListener[1];
        } else {
            CVSListener[] cVSListenerArray = new CVSListener[this.listeners.length + 1];
            for (int i = 0; i < this.listeners.length; ++i) {
                cVSListenerArray[i] = this.listeners[i];
            }
            this.listeners = cVSListenerArray;
        }
        this.listeners[this.listeners.length - 1] = cVSListener;
    }

    public synchronized void removeCVSListener(CVSListener cVSListener) {
        if (this.listeners.length == 1) {
            this.listeners = null;
        } else {
            CVSListener[] cVSListenerArray = new CVSListener[this.listeners.length - 1];
            for (int i = 0; i < cVSListenerArray.length; ++i) {
                if (this.listeners[i] == cVSListener) {
                    for (int j = i + 1; j < this.listeners.length; ++j) {
                        cVSListenerArray[j - 1] = this.listeners[j];
                    }
                    break;
                }
                cVSListenerArray[i] = this.listeners[i];
            }
            this.listeners = cVSListenerArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireCVSEvent(CVSEvent cVSEvent) {
        CVSListener[] cVSListenerArray;
        if (this.listeners == null || this.listeners.length == 0) {
            return;
        }
        if (cVSEvent instanceof FileInfoEvent) {
            cVSListenerArray = ((FileInfoEvent)cVSEvent).getInfoContainer().getFile();
            if (this.services.getGlobalOptions().isExcluded((File)cVSListenerArray)) {
                return;
            }
        }
        cVSListenerArray = null;
        CVSListener[] cVSListenerArray2 = this.listeners;
        synchronized (this.listeners) {
            cVSListenerArray = new CVSListener[this.listeners.length];
            System.arraycopy(this.listeners, 0, cVSListenerArray, 0, cVSListenerArray.length);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            for (int i = 0; i < cVSListenerArray.length; ++i) {
                cVSEvent.fireEvent(cVSListenerArray[i]);
            }
            return;
        }
    }

    public boolean isFireEnhancedEventSet() {
        return this.fireEnhancedEventSet;
    }

    public void setFireEnhancedEventSet(boolean bl) {
        this.fireEnhancedEventSet = bl;
    }
}

