/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.path;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.NodeConflictBehavior;
import org.modeshape.graph.connector.LockFailedException;
import org.modeshape.graph.connector.path.PathNode;
import org.modeshape.graph.connector.path.PathWorkspace;
import org.modeshape.graph.connector.path.WritablePathWorkspace;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.query.QueryResults;
import org.modeshape.graph.request.AccessQueryRequest;
import org.modeshape.graph.request.LockBranchRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWritablePathWorkspace
implements WritablePathWorkspace {
    private final String name;
    protected final UUID rootNodeUuid;

    public AbstractWritablePathWorkspace(String name, UUID rootNodeUuid) {
        this.name = name;
        this.rootNodeUuid = rootNodeUuid;
    }

    @Override
    public PathNode copyNode(ExecutionContext context, PathNode original, PathWorkspace originalWorkspace, PathNode newParent, Name desiredName, boolean recursive) {
        PathFactory pathFactory = context.getValueFactories().getPathFactory();
        PathNode copy = this.createNode(context, newParent, desiredName, original.getProperties(), NodeConflictBehavior.REPLACE);
        if (recursive) {
            Path originalPath = original.getPath();
            for (Path.Segment childSegment : original.getChildSegments()) {
                Path childPath = pathFactory.create(originalPath, childSegment);
                PathNode childNode = originalWorkspace.getNode(childPath);
                this.copyNode(context, childNode, originalWorkspace, copy, childSegment.getName(), true);
            }
        }
        return copy;
    }

    @Override
    public PathNode createNode(ExecutionContext context, String pathToNewNode, Map<Name, Property> properties, NodeConflictBehavior conflictBehavior) {
        PathFactory pathFactory = context.getValueFactories().getPathFactory();
        Path newPath = (Path)pathFactory.create(pathToNewNode);
        return this.createNode(context, this.getNode(newPath.getParent()), newPath.getLastSegment().getName(), properties, conflictBehavior);
    }

    @Override
    public PathNode moveNode(ExecutionContext context, PathNode node, Name desiredNewName, WritablePathWorkspace originalWorkspace, PathNode newParent, PathNode beforeNode) {
        if (desiredNewName == null) {
            assert (!node.getPath().isRoot());
            desiredNewName = node.getPath().getLastSegment().getName();
        }
        PathNode newCopy = this.copyNode(context, node, originalWorkspace, newParent, desiredNewName, true);
        originalWorkspace.removeNode(context, node.getPath());
        return newCopy;
    }

    @Override
    public PathNode removeProperties(ExecutionContext context, Path nodePath, Iterable<Name> propertyNames) {
        HashMap<Name, Property> properties = new HashMap<Name, Property>();
        for (Name propertyName : propertyNames) {
            properties.put(propertyName, null);
        }
        return this.setProperties(context, nodePath, properties);
    }

    @Override
    public QueryResults query(ExecutionContext context, AccessQueryRequest accessQuery) {
        return null;
    }

    @Override
    public QueryResults search(ExecutionContext context, String fullTextSearchExpression) {
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void lockNode(PathNode node, LockBranchRequest.LockScope lockScope, long lockTimeoutInMillis) throws LockFailedException {
    }

    @Override
    public void unlockNode(PathNode node) {
    }
}

