/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.federation;

import java.util.List;
import java.util.Set;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Location;
import org.modeshape.graph.connector.federation.PlaceholderNode;
import org.modeshape.graph.connector.federation.ProjectedNode;
import org.modeshape.graph.connector.federation.Projection;
import org.modeshape.graph.connector.federation.ProjectorWithPlaceholders;
import org.modeshape.graph.connector.federation.ProxyNode;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class GeneralProjector
extends ProjectorWithPlaceholders {
    private final List<Projection> projections;

    static GeneralProjector with(ExecutionContext context, List<Projection> projections) {
        assert (projections != null);
        assert (context != null);
        return new GeneralProjector(context, projections);
    }

    private GeneralProjector(ExecutionContext context, List<Projection> projections) {
        super(context, projections);
        this.projections = projections;
    }

    @Override
    public ProjectedNode project(ExecutionContext context, Location location, boolean requiresUpdate) {
        PlaceholderNode placeholder = this.isPlaceholder(location);
        if (placeholder != null) {
            return placeholder;
        }
        Path path = location.getPath();
        if (path == null) {
            ProxyNode result = null;
            for (Projection projection : this.projections) {
                if (requiresUpdate && projection.isReadOnly()) continue;
                ProxyNode proxy = new ProxyNode(projection, location, location, false);
                if (result == null) {
                    result = proxy;
                    continue;
                }
                result.add(proxy);
            }
            return result;
        }
        ProjectedNode result = this.isPlaceholder(location);
        if (result != null) {
            return result;
        }
        PathFactory pathFactory = context.getValueFactories().getPathFactory();
        for (Projection projection : this.projections) {
            if (requiresUpdate && projection.isReadOnly()) continue;
            Set<Path> pathsInSource = projection.getPathsInSource(path, pathFactory);
            for (Path pathInSource : pathsInSource) {
                Location locationInSource = Location.create(pathInSource);
                boolean samePath = pathInSource.equals(path);
                ProxyNode proxy = new ProxyNode(projection, locationInSource, location, samePath);
                if (result == null) {
                    result = proxy;
                    continue;
                }
                result.add(proxy);
            }
        }
        if (result != null && !result.hasNext() && ((ProjectedNode)result).isProxy()) {
            ProxyNode proxy = ((ProjectedNode)result).asProxy();
            result = new ProxyNode(proxy.projection(), location.with(result.location().getPath()), location, proxy.isSameLocationAsOriginal());
        }
        return result;
    }
}

