/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.request;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.Location;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.request.ChangeRequest;
import org.modeshape.graph.request.PropertyChangeRequest;
import org.modeshape.graph.request.RequestType;

public class UpdatePropertiesRequest
extends ChangeRequest
implements PropertyChangeRequest {
    private static final long serialVersionUID = 1L;
    private final Location on;
    private final String workspaceName;
    private final Map<Name, Property> properties;
    private final boolean removeOtherProperties;
    private Set<Name> createdPropertyNames;
    private Location actualLocation;

    public UpdatePropertiesRequest(Location on, String workspaceName, Map<Name, Property> properties) {
        this(on, workspaceName, properties, false);
    }

    public UpdatePropertiesRequest(Location on, String workspaceName, Map<Name, Property> properties, boolean removeOtherProperties) {
        CheckArg.isNotNull((Object)on, (String)"on");
        CheckArg.isNotEmpty(properties, (String)"properties");
        CheckArg.isNotNull((Object)workspaceName, (String)"workspaceName");
        this.workspaceName = workspaceName;
        this.on = on;
        this.properties = Collections.unmodifiableMap(properties);
        this.removeOtherProperties = removeOtherProperties;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public Location on() {
        return this.on;
    }

    public String inWorkspace() {
        return this.workspaceName;
    }

    public Map<Name, Property> properties() {
        return this.properties;
    }

    public boolean removeOtherProperties() {
        return this.removeOtherProperties;
    }

    public void setActualLocationOfNode(Location actual) {
        this.checkNotFrozen();
        CheckArg.isNotNull((Object)actual, (String)"actual");
        if (!actual.hasPath()) {
            throw new IllegalArgumentException(GraphI18n.actualLocationMustHavePath.text(new Object[]{actual}));
        }
        this.actualLocation = actual;
    }

    public Location getActualLocationOfNode() {
        return this.actualLocation;
    }

    public void setNewProperty(Name nameOfCreatedProperty) {
        CheckArg.isNotNull((Object)nameOfCreatedProperty, (String)"nameOfCreatedProperty");
        this.checkNotFrozen();
        if (!this.properties().containsKey(nameOfCreatedProperty)) {
            throw new IllegalStateException(GraphI18n.propertyIsNotPartOfRequest.text(new Object[]{nameOfCreatedProperty, this}));
        }
        if (this.createdPropertyNames == null) {
            this.createdPropertyNames = new HashSet<Name>();
        }
        this.createdPropertyNames.add(nameOfCreatedProperty);
    }

    public void setNewProperties(Name ... nameOfCreatedProperties) {
        this.checkNotFrozen();
        if (this.createdPropertyNames == null) {
            this.createdPropertyNames = new HashSet<Name>();
        }
        for (Name name : nameOfCreatedProperties) {
            if (name == null) continue;
            if (!this.properties().containsKey(name)) {
                throw new IllegalStateException(GraphI18n.propertyIsNotPartOfRequest.text(new Object[]{name, this}));
            }
            this.createdPropertyNames.add(name);
        }
    }

    public void setNewProperties(Iterable<Name> nameOfCreatedProperties) {
        this.checkNotFrozen();
        if (nameOfCreatedProperties == null) {
            return;
        }
        if (this.createdPropertyNames == null) {
            this.createdPropertyNames = new HashSet<Name>();
        }
        for (Name name : nameOfCreatedProperties) {
            if (name == null) continue;
            if (!this.properties().containsKey(name)) {
                throw new IllegalStateException(GraphI18n.propertyIsNotPartOfRequest.text(new Object[]{name, this}));
            }
            this.createdPropertyNames.add(name);
        }
    }

    public Set<Name> getNewPropertyNames() {
        return this.createdPropertyNames;
    }

    public boolean isNewProperty(Name name) {
        return this.createdPropertyNames != null && this.createdPropertyNames.contains(name);
    }

    public boolean isAllNewProperties() {
        return this.createdPropertyNames != null && this.createdPropertyNames.containsAll(this.properties.values());
    }

    @Override
    public boolean freeze() {
        if (super.freeze()) {
            if (this.createdPropertyNames != null) {
                this.createdPropertyNames = this.createdPropertyNames.isEmpty() ? Collections.emptySet() : (this.createdPropertyNames.size() == 1 ? Collections.singleton(this.createdPropertyNames.iterator().next()) : Collections.unmodifiableSet(this.createdPropertyNames));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean changes(String workspace, Path path) {
        return this.workspaceName.equals(workspace) && this.on.hasPath() && this.on.getPath().isAtOrBelow(path);
    }

    @Override
    public void cancel() {
        super.cancel();
        this.actualLocation = null;
    }

    public int hashCode() {
        return HashCode.compute((Object[])new Object[]{this.on, this.workspaceName});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (this.getClass().isInstance(obj)) {
            UpdatePropertiesRequest that = (UpdatePropertiesRequest)obj;
            if (!this.on().isSame(that.on())) {
                return false;
            }
            if (!((Object)this.properties()).equals(that.properties())) {
                return false;
            }
            return this.inWorkspace().equals(that.inWorkspace());
        }
        return false;
    }

    @Override
    public Location changedLocation() {
        return this.actualLocation != null ? this.actualLocation : this.on;
    }

    @Override
    public String changedWorkspace() {
        return this.workspaceName;
    }

    public String toString() {
        if (this.removeOtherProperties) {
            return "update (and remove other) properties on " + this.on() + " in the \"" + this.workspaceName + "\" workspace to " + this.properties();
        }
        return "update properties on " + this.on() + " in the \"" + this.workspaceName + "\" workspace to " + this.properties();
    }

    @Override
    public UpdatePropertiesRequest clone() {
        UpdatePropertiesRequest request = new UpdatePropertiesRequest(this.actualLocation != null ? this.actualLocation : this.on, this.workspaceName, this.properties, this.removeOtherProperties);
        request.setActualLocationOfNode(this.actualLocation);
        request.setNewProperties(this.createdPropertyNames);
        return request;
    }

    @Override
    public RequestType getType() {
        return RequestType.UPDATE_PROPERTIES;
    }
}

