/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.example.sequencer;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.example.sequencer.ContentInfo;

@Immutable
public class JavaInfo
extends ContentInfo {
    private final Map<String, List<Properties>> javaElements;
    private final String type;

    protected JavaInfo(String path, String name, String type, Map<String, List<Properties>> javaElements) {
        super(path, name, null);
        this.type = type;
        this.javaElements = javaElements != null ? new TreeMap<String, List<Properties>>(javaElements) : new TreeMap();
    }

    public String getType() {
        return this.type;
    }

    public Map<String, List<Properties>> getJavaElements() {
        return this.javaElements;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("   Name: " + this.getName() + "\n");
        sb.append("   Path: " + this.getPath() + "\n");
        sb.append("   Type: " + this.getType() + "\n");
        for (Map.Entry<Object, Object> entry : this.getProperties().entrySet()) {
            sb.append("   " + entry.getKey() + ": " + entry.getValue() + "\n");
        }
        for (Map.Entry<Object, Object> entry : this.getJavaElements().entrySet()) {
            sb.append("\n   ------ " + (String)entry.getKey() + " ------\n");
            for (Properties props : (List)entry.getValue()) {
                for (Map.Entry<Object, Object> entry2 : props.entrySet()) {
                    if (entry2.getKey().equals("jcr:primaryType")) continue;
                    sb.append("   " + entry2.getKey() + " => " + entry2.getValue() + "\n");
                }
            }
        }
        return sb.toString();
    }
}

