/*
 * Decompiled with CFR 0.152.
 */
package org.jpastebin.pastebin.account;

import java.io.ByteArrayInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jpastebin.pastebin.PasteExpireDate;
import org.jpastebin.pastebin.PastebinLink;
import org.jpastebin.pastebin.PastebinPaste;
import org.jpastebin.pastebin.account.PastebinAccountDetails;
import org.jpastebin.pastebin.exceptions.LoginException;
import org.jpastebin.pastebin.exceptions.ParseException;
import org.jpastebin.utils.web.Post;
import org.jpastebin.utils.web.Web;
import org.jpastebin.utils.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class PastebinAccount {
    private String username;
    private String password;
    private String userSessionId;
    private String developerKey;

    public PastebinAccount() {
        this(null, null, null);
    }

    public PastebinAccount(String developerKey, String username, String password) {
        this.developerKey = developerKey;
        this.username = username;
        this.password = password;
    }

    public PastebinAccount(String userSessionId) {
        this(null, userSessionId);
    }

    public PastebinAccount(String developerKey, String userSessionId) {
        this.developerKey = developerKey;
        this.userSessionId = userSessionId;
    }

    public void setUserSessionId(String userSessionId) {
        this.userSessionId = userSessionId;
    }

    public String getUserSessionId() {
        return this.userSessionId;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setDeveloperKey(String developerKey) {
        if (developerKey == null || developerKey.isEmpty()) {
            throw new IllegalArgumentException("Developer key can not be null or empty.");
        }
        this.developerKey = developerKey;
    }

    public String getDeveloperKey() {
        return this.developerKey;
    }

    public void login() throws LoginException {
        if (this.getUserSessionId() != null) {
            throw new IllegalStateException("Already logged in.");
        }
        if (this.getUsername() == null || this.getPassword() == null) {
            throw new IllegalStateException("Username or password null.");
        }
        if (this.getDeveloperKey() == null || this.getDeveloperKey().isEmpty()) {
            throw new IllegalStateException("Developer key is missing.");
        }
        Post post = new Post();
        post.put("api_dev_key", this.getDeveloperKey());
        post.put("api_user_name", this.username);
        post.put("api_user_password", this.password);
        String response = Web.getContents("https://pastebin.com/api/api_login.php", post);
        if (response == null || response.isEmpty()) {
            throw new LoginException("Empty response from login API server.");
        }
        if (response.toLowerCase().startsWith("bad")) {
            throw new LoginException("Failed to login: " + response);
        }
        this.userSessionId = response;
    }

    public PastebinLink[] getPastes(int limit) throws ParseException {
        if (limit > 1000) {
            limit = 1000;
        }
        if (limit < 1) {
            limit = 1;
        }
        if (this.getUserSessionId() == null) {
            throw new IllegalStateException("User session id missing.");
        }
        if (this.getDeveloperKey() == null || this.getDeveloperKey().isEmpty()) {
            throw new IllegalStateException("Developer key is missing.");
        }
        Post post = new Post();
        post.put("api_dev_key", this.getDeveloperKey());
        post.put("api_user_key", this.getUserSessionId());
        post.put("api_results_limit", Integer.toString(limit));
        post.put("api_option", "list");
        String response = Web.getContents("https://pastebin.com/api/api_post.php", post);
        if (response.equals("No pastes found.")) {
            return null;
        }
        if (response.startsWith("<paste>")) {
            try {
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                response = "<dummy>" + response + "</dummy>";
                Document doc = dBuilder.parse(new InputSource(new ByteArrayInputStream(response.getBytes("utf-8"))));
                doc.getDocumentElement().normalize();
                NodeList nodes = doc.getElementsByTagName("paste");
                ArrayList<PastebinLink> pastes = new ArrayList<PastebinLink>(nodes.getLength());
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node node = nodes.item(i);
                    if (node.getNodeType() != 1) continue;
                    Element element = (Element)node;
                    String pasteFormat = XMLUtils.getText(element, "paste_format_short");
                    String title = XMLUtils.getText(element, "paste_title");
                    int visibility = Integer.parseInt(XMLUtils.getText(element, "paste_private"));
                    int hits = Integer.parseInt(XMLUtils.getText(element, "paste_hits"));
                    long expireDate = Long.parseLong(XMLUtils.getText(element, "paste_expire_date"));
                    long pasteDate = Long.parseLong(XMLUtils.getText(element, "paste_date"));
                    URL pasteURL = new URL(XMLUtils.getText(element, "paste_url"));
                    PastebinPaste paste = new PastebinPaste(this);
                    paste.setPasteFormat(pasteFormat);
                    paste.setPasteTitle(title);
                    paste.setVisibility(visibility);
                    paste.setPasteExpireDate(expireDate == 0L ? PasteExpireDate.NEVER : PasteExpireDate.getExpireDate((int)(expireDate - pasteDate)));
                    PastebinLink pastebinLink = new PastebinLink(paste, pasteURL, new Date(pasteDate * 1000L));
                    pastebinLink.setHits(hits);
                    pastes.add(pastebinLink);
                }
                return pastes.toArray(new PastebinLink[pastes.size()]);
            }
            catch (Exception e) {
                throw new ParseException("Failed to parse pastes: " + e.getMessage());
            }
        }
        throw new ParseException("Failed to parse pastes: " + response);
    }

    public PastebinLink[] getPastes() throws ParseException {
        return this.getPastes(50);
    }

    public PastebinAccountDetails getAccountDetails() throws ParseException {
        if (this.getUserSessionId() == null) {
            throw new IllegalStateException("User session id missing.");
        }
        if (this.getDeveloperKey() == null || this.getDeveloperKey().isEmpty()) {
            throw new IllegalStateException("Developer key is missing.");
        }
        Post post = new Post();
        post.put("api_dev_key", this.getDeveloperKey());
        post.put("api_user_key", this.getUserSessionId());
        post.put("api_option", "userdetails");
        String response = Web.getContents("https://pastebin.com/api/api_post.php", post);
        if (!response.startsWith("<user>")) {
            throw new ParseException("Failed to parse account details: " + response);
        }
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(new InputSource(new ByteArrayInputStream(response.getBytes("utf-8"))));
            doc.getDocumentElement().normalize();
            return new PastebinAccountDetails((Element)doc.getElementsByTagName("user").item(0));
        }
        catch (Exception e) {
            throw new ParseException("Failed to parse account details: " + e);
        }
    }
}

