/*
 * Decompiled with CFR 0.152.
 */
package org.jpastebin.pastebin;

import java.net.URISyntaxException;
import java.net.URL;
import java.util.Date;
import org.jpastebin.AbstractPasteLink;
import org.jpastebin.exceptions.PasteException;
import org.jpastebin.pastebin.PastebinPaste;
import org.jpastebin.pastebin.account.PastebinAccount;
import org.jpastebin.utils.web.Post;
import org.jpastebin.utils.web.Web;

public class PastebinLink
extends AbstractPasteLink {
    private PastebinPaste paste;
    private URL link;
    private int hits;
    private String key;
    private Date pasteDate;

    public PastebinLink(PastebinPaste paste, URL url) {
        this(paste, url, new Date(System.currentTimeMillis() / 1000L * 1000L));
    }

    public PastebinLink(PastebinPaste paste, URL url, Date pasteDate) {
        this.paste = paste;
        this.link = url;
        this.pasteDate = pasteDate;
        try {
            this.key = url.toURI().getPath().substring(1);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    @Override
    public URL getLink() {
        return this.link;
    }

    public PastebinPaste getPaste() {
        return this.paste;
    }

    public String getKey() {
        return this.key;
    }

    public void fetchContent() {
        if (this.getPaste().getContents() != null) {
            throw new IllegalStateException("Contents already fetched.");
        }
        this.getPaste().setContents(PastebinLink.getContents(this.getKey()));
    }

    public void setHits(int hits) {
        if (hits < 0) {
            throw new IllegalArgumentException("Hits must be positive: " + hits);
        }
        this.hits = hits;
    }

    public int getHits() {
        return this.hits;
    }

    public Date getPasteDate() {
        return this.pasteDate;
    }

    public void delete(String developerKey, PastebinAccount account) throws PasteException {
        if (developerKey == null || developerKey.isEmpty()) {
            throw new IllegalArgumentException("Developer key can't be null or empty.");
        }
        if (account.getUserSessionId() == null || account.getUserSessionId().isEmpty()) {
            throw new IllegalArgumentException("Account user session id is missing.");
        }
        Post post = new Post();
        post.put("api_dev_key", developerKey);
        post.put("api_user_key", account.getUserSessionId());
        post.put("api_paste_key", this.getKey());
        post.put("api_option", "delete");
        String response = Web.getContents("https://pastebin.com/api/api_post.php", post);
        if (response.equals("Paste Removed")) {
            return;
        }
        throw new PasteException("Failed to delete paste: " + response);
    }

    public void delete() throws PasteException {
        this.delete(this.getPaste().getDeveloperKey(), this.getPaste().getAccount());
    }

    public static String getContents(String pasteKey) {
        return Web.getContents("https://pastebin.com/raw.php?i=" + pasteKey);
    }
}

