/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.subprocess.outcomevalue;

import java.util.HashMap;
import java.util.List;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.task.Task;
import org.jbpm.test.JbpmTestCase;

public class SubProcessOutcomeValueTest
extends JbpmTestCase {
    String subProcessReviewDeploymentId;
    String subProcessDocumentDeploymentId;

    protected void setUp() throws Exception {
        super.setUp();
        this.subProcessReviewDeploymentId = this.repositoryService.createDeployment().addResourceFromClasspath("org/jbpm/examples/subprocess/outcomevalue/SubProcessReview.jpdl.xml").deploy();
        this.subProcessDocumentDeploymentId = this.repositoryService.createDeployment().addResourceFromClasspath("org/jbpm/examples/subprocess/outcomevalue/SubProcessDocument.jpdl.xml").deploy();
    }

    protected void tearDown() throws Exception {
        this.repositoryService.deleteDeploymentCascade(this.subProcessReviewDeploymentId);
        this.repositoryService.deleteDeploymentCascade(this.subProcessDocumentDeploymentId);
        super.tearDown();
    }

    public void testSubProcessResultOk() {
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("SubProcessDocument");
        SubProcessOutcomeValueTest.assertNotNull((Object)processInstance.findActiveExecutionIn("review"));
        List taskList = this.taskService.findPersonalTasks("johndoe");
        Task task = (Task)taskList.get(0);
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("result", "ok");
        this.taskService.setVariables(task.getId(), variables);
        this.taskService.completeTask(task.getId());
        processInstance = this.executionService.findProcessInstanceById(processInstance.getId());
        SubProcessOutcomeValueTest.assertNotNull((Object)processInstance.findActiveExecutionIn("next step"));
    }

    public void testSubProcessResultNok() {
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("SubProcessDocument");
        SubProcessOutcomeValueTest.assertNotNull((Object)processInstance.findActiveExecutionIn("review"));
        List taskList = this.taskService.findPersonalTasks("johndoe");
        Task task = (Task)taskList.get(0);
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("result", "nok");
        this.taskService.setVariables(task.getId(), variables);
        this.taskService.completeTask(task.getId());
        processInstance = this.executionService.findProcessInstanceById(processInstance.getId());
        SubProcessOutcomeValueTest.assertNotNull((Object)processInstance.findActiveExecutionIn("update"));
    }

    public void testSubProcessResultReject() {
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("SubProcessDocument");
        SubProcessOutcomeValueTest.assertNotNull((Object)processInstance.findActiveExecutionIn("review"));
        List taskList = this.taskService.findPersonalTasks("johndoe");
        Task task = (Task)taskList.get(0);
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("result", "reject");
        this.taskService.setVariables(task.getId(), variables);
        this.taskService.completeTask(task.getId());
        processInstance = this.executionService.findProcessInstanceById(processInstance.getId());
        SubProcessOutcomeValueTest.assertNotNull((Object)processInstance.findActiveExecutionIn("close"));
    }
}

