/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.subprocess.outcomeactivity;

import java.util.List;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.task.Task;
import org.jbpm.test.JbpmTestCase;

public class SubProcessOutcomeActivityTest
extends JbpmTestCase {
    String subProcessReviewDeploymentId;
    String subProcessDocumentDeploymentId;

    protected void setUp() throws Exception {
        super.setUp();
        this.subProcessReviewDeploymentId = this.repositoryService.createDeployment().addResourceFromClasspath("org/jbpm/examples/subprocess/outcomeactivity/SubProcessReview.jpdl.xml").deploy();
        this.subProcessDocumentDeploymentId = this.repositoryService.createDeployment().addResourceFromClasspath("org/jbpm/examples/subprocess/outcomeactivity/SubProcessDocument.jpdl.xml").deploy();
    }

    protected void tearDown() throws Exception {
        this.repositoryService.deleteDeploymentCascade(this.subProcessReviewDeploymentId);
        this.repositoryService.deleteDeploymentCascade(this.subProcessDocumentDeploymentId);
        super.tearDown();
    }

    public void testSubProcessResultOk() {
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("SubProcessDocument");
        SubProcessOutcomeActivityTest.assertNotNull((Object)processInstance.findActiveExecutionIn("review"));
        List taskList = this.taskService.findPersonalTasks("johndoe");
        Task task = (Task)taskList.get(0);
        this.taskService.completeTask(task.getId(), "ok");
        processInstance = this.executionService.findProcessInstanceById(processInstance.getId());
        SubProcessOutcomeActivityTest.assertNotNull((Object)processInstance.findActiveExecutionIn("next step"));
    }

    public void testSubProcessResultNok() {
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("SubProcessDocument");
        SubProcessOutcomeActivityTest.assertNotNull((Object)processInstance.findActiveExecutionIn("review"));
        List taskList = this.taskService.findPersonalTasks("johndoe");
        Task task = (Task)taskList.get(0);
        this.taskService.completeTask(task.getId(), "nok");
        processInstance = this.executionService.findProcessInstanceById(processInstance.getId());
        SubProcessOutcomeActivityTest.assertNotNull((Object)processInstance.findActiveExecutionIn("update"));
    }

    public void testSubProcessResultReject() {
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("SubProcessDocument");
        SubProcessOutcomeActivityTest.assertNotNull((Object)processInstance.findActiveExecutionIn("review"));
        List taskList = this.taskService.findPersonalTasks("johndoe");
        Task task = (Task)taskList.get(0);
        this.taskService.completeTask(task.getId(), "reject");
        processInstance = this.executionService.findProcessInstanceById(processInstance.getId());
        SubProcessOutcomeActivityTest.assertNotNull((Object)processInstance.findActiveExecutionIn("close"));
    }
}

