/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.task.TaskLifeCycleEventListener;
import org.kie.api.task.TaskService;
import org.kie.internal.runtime.manager.InternalRegisterableItemsFactory;
import org.kie.internal.runtime.manager.InternalRuntimeManager;

public class SimpleRegisterableItemsFactory
implements InternalRegisterableItemsFactory {
    private Map<String, Class<? extends WorkItemHandler>> workItemHandlersClasses = new ConcurrentHashMap<String, Class<? extends WorkItemHandler>>();
    private List<Class<? extends ProcessEventListener>> processListeners = new CopyOnWriteArrayList<Class<? extends ProcessEventListener>>();
    private List<Class<? extends AgendaEventListener>> agendListeners = new CopyOnWriteArrayList<Class<? extends AgendaEventListener>>();
    private List<Class<? extends RuleRuntimeEventListener>> workingMemoryListeners = new CopyOnWriteArrayList<Class<? extends RuleRuntimeEventListener>>();
    private List<Class<? extends TaskLifeCycleEventListener>> taskListeners = new CopyOnWriteArrayList<Class<? extends TaskLifeCycleEventListener>>();
    private Map<String, Object> globals = new ConcurrentHashMap<String, Object>();
    protected InternalRuntimeManager runtimeManager;

    public InternalRuntimeManager getRuntimeManager() {
        return this.runtimeManager;
    }

    public void setRuntimeManager(InternalRuntimeManager runtimeManager) {
        this.runtimeManager = runtimeManager;
    }

    public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
        HashMap<String, WorkItemHandler> handlers = new HashMap<String, WorkItemHandler>();
        for (Map.Entry<String, Class<? extends WorkItemHandler>> entry : this.workItemHandlersClasses.entrySet()) {
            WorkItemHandler handler = this.createInstance(entry.getValue(), runtime);
            if (handler == null) continue;
            handlers.put(entry.getKey(), handler);
        }
        return handlers;
    }

    public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
        ArrayList<ProcessEventListener> listeners = new ArrayList<ProcessEventListener>();
        for (Class<? extends ProcessEventListener> clazz : this.processListeners) {
            ProcessEventListener pListener = this.createInstance(clazz, runtime);
            if (pListener == null) continue;
            listeners.add(pListener);
        }
        return listeners;
    }

    public List<AgendaEventListener> getAgendaEventListeners(RuntimeEngine runtime) {
        ArrayList<AgendaEventListener> listeners = new ArrayList<AgendaEventListener>();
        for (Class<? extends AgendaEventListener> clazz : this.agendListeners) {
            AgendaEventListener aListener = this.createInstance(clazz, runtime);
            if (aListener == null) continue;
            listeners.add(aListener);
        }
        return listeners;
    }

    public List<RuleRuntimeEventListener> getRuleRuntimeEventListeners(RuntimeEngine runtime) {
        ArrayList<RuleRuntimeEventListener> listeners = new ArrayList<RuleRuntimeEventListener>();
        for (Class<? extends RuleRuntimeEventListener> clazz : this.workingMemoryListeners) {
            RuleRuntimeEventListener wmListener = this.createInstance(clazz, runtime);
            if (wmListener == null) continue;
            listeners.add(wmListener);
        }
        return listeners;
    }

    public List<TaskLifeCycleEventListener> getTaskListeners() {
        ArrayList<TaskLifeCycleEventListener> listeners = new ArrayList<TaskLifeCycleEventListener>();
        for (Class<? extends TaskLifeCycleEventListener> clazz : this.taskListeners) {
            TaskLifeCycleEventListener tListener = this.createInstance(clazz, null);
            if (tListener == null) continue;
            listeners.add(tListener);
        }
        return listeners;
    }

    public Map<String, Object> getGlobals(RuntimeEngine runtime) {
        return this.globals;
    }

    public void addWorkItemHandler(String name, Class<? extends WorkItemHandler> clazz) {
        this.workItemHandlersClasses.put(name, clazz);
    }

    public void addProcessListener(Class<? extends ProcessEventListener> clazz) {
        this.processListeners.add(clazz);
    }

    public void addAgendaListener(Class<? extends AgendaEventListener> clazz) {
        this.agendListeners.add(clazz);
    }

    public void addWorkingMemoryListener(Class<? extends RuleRuntimeEventListener> clazz) {
        this.workingMemoryListeners.add(clazz);
    }

    public void addGlobal(String name, Object global) {
        this.globals.put(name, global);
    }

    public void addTaskListener(Class<? extends TaskLifeCycleEventListener> clazz) {
        this.taskListeners.add(clazz);
    }

    protected <T> T createInstance(Class<T> clazz, RuntimeEngine engine) {
        T instance = null;
        if (engine != null) {
            Constructor<T> constructor2;
            try {
                constructor2 = clazz.getConstructor(KieSession.class);
                instance = constructor2.newInstance(engine.getKieSession());
            }
            catch (Exception constructor2) {
                // empty catch block
            }
            try {
                constructor2 = clazz.getConstructor(TaskService.class);
                instance = constructor2.newInstance(engine.getTaskService());
            }
            catch (Exception constructor3) {
                // empty catch block
            }
            try {
                constructor2 = clazz.getConstructor(RuntimeEngine.class);
                instance = constructor2.newInstance(engine);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (instance == null) {
            try {
                instance = clazz.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return instance;
    }
}

