/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.commands;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManagerFactory;
import org.jbpm.process.audit.NodeInstanceLog;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.process.core.timer.DateTimeUtils;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.jbpm.shared.services.impl.commands.QueryStringCommand;
import org.kie.api.command.Command;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ExecutionResults;
import org.kie.api.executor.Reoccurring;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.internal.runtime.manager.RuntimeManagerRegistry;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SLATrackingCommand
implements org.kie.api.executor.Command,
Reoccurring {
    private static final Logger logger = LoggerFactory.getLogger(SLATrackingCommand.class);
    private long nextScheduleTimeAdd = 3600000L;

    public Date getScheduleTime() {
        if (this.nextScheduleTimeAdd < 0L) {
            return null;
        }
        long current = System.currentTimeMillis();
        Date nextSchedule = new Date(current + this.nextScheduleTimeAdd);
        logger.debug("Next schedule for job {} is set to {}", (Object)this.getClass().getSimpleName(), (Object)nextSchedule);
        return nextSchedule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutionResults execute(CommandContext ctx) throws Exception {
        String nextRun;
        String singleRun;
        ExecutionResults executionResults = new ExecutionResults();
        String emfName = (String)ctx.getData("EmfName");
        if (emfName == null) {
            emfName = "org.jbpm.domain";
        }
        if ("true".equalsIgnoreCase(singleRun = (String)ctx.getData("SingleRun"))) {
            this.nextScheduleTimeAdd = -1L;
        }
        if ((nextRun = (String)ctx.getData("NextRun")) != null) {
            this.nextScheduleTimeAdd = DateTimeUtils.parseDateAsDuration((String)nextRun);
        }
        EntityManagerFactory emf = EntityManagerFactoryManager.get().getOrCreate(emfName);
        String forDeployment = (String)ctx.getData("ForDeployment");
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("now", new Date());
        StringBuilder lookupQuery = new StringBuilder();
        lookupQuery.append("select log from NodeInstanceLog log where ");
        lookupQuery.append("log.nodeInstanceId in ( select nil.nodeInstanceId from NodeInstanceLog nil where nil.slaDueDate < :now and nil.slaCompliance = 1 ");
        lookupQuery.append("GROUP BY nil.nodeInstanceId ");
        lookupQuery.append("HAVING sum(nil.type) = 0) ");
        lookupQuery.append("and log.type = 0 ");
        if (forDeployment != null && !forDeployment.isEmpty()) {
            lookupQuery.append(" and log.externalId = :forDeployment");
            parameters.put("forDeployment", forDeployment);
        }
        TransactionalCommandService commandService = new TransactionalCommandService(emf);
        List nodeInstancesViolations = (List)commandService.execute((Command)new QueryStringCommand(lookupQuery.toString(), parameters));
        logger.debug("Number of node instances with violated SLA {}", (Object)nodeInstancesViolations.size());
        if (!nodeInstancesViolations.isEmpty()) {
            logger.debug("Signaling process instances that have SLA violations on nodes");
            int nodeSignals = 0;
            for (NodeInstanceLog niLog : nodeInstancesViolations) {
                RuntimeManager runtimeManager = RuntimeManagerRegistry.get().getManager(niLog.getExternalId());
                if (runtimeManager == null) {
                    logger.debug("No runtime manager found for {}, not able to send SLA violation signal", (Object)niLog.getExternalId());
                    continue;
                }
                RuntimeEngine engine = runtimeManager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)niLog.getProcessInstanceId()));
                try {
                    engine.getKieSession().signalEvent("slaViolation:" + niLog.getNodeInstanceId(), null, niLog.getProcessInstanceId().longValue());
                    ++nodeSignals;
                }
                catch (Exception e) {
                    logger.warn("Unexpected error when signalig process instance {} about SLA violation {}", new Object[]{niLog.getProcessInstanceId(), e.getMessage(), e});
                }
                finally {
                    runtimeManager.disposeRuntimeEngine(engine);
                }
            }
            logger.info("SLA Violations JOB :: Number of nodes successfully signaled is {}", (Object)nodeSignals);
            executionResults.setData("NodeSLASignals", (Object)nodeSignals);
        }
        parameters = new HashMap();
        parameters.put("now", new Date());
        lookupQuery = new StringBuilder();
        lookupQuery.append("select log from ProcessInstanceLog log where log.slaDueDate < :now and log.slaCompliance = 1 ");
        if (forDeployment != null && !forDeployment.isEmpty()) {
            lookupQuery.append(" and log.externalId = :forDeployment");
            parameters.put("forDeployment", forDeployment);
        }
        List processInstancesViolations = (List)commandService.execute((Command)new QueryStringCommand(lookupQuery.toString(), parameters));
        logger.debug("Number of node instances with violated SLA {}", (Object)nodeInstancesViolations.size());
        if (!processInstancesViolations.isEmpty()) {
            logger.debug("Signaling process instances that have SLA violations");
            int processSignals = 0;
            for (ProcessInstanceLog piLog : processInstancesViolations) {
                RuntimeManager runtimeManager = RuntimeManagerRegistry.get().getManager(piLog.getExternalId());
                if (runtimeManager == null) {
                    logger.debug("No runtime manager found for {}, not able to send SLA violation signal", (Object)piLog.getExternalId());
                    continue;
                }
                RuntimeEngine engine = runtimeManager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)piLog.getProcessInstanceId()));
                try {
                    engine.getKieSession().signalEvent("slaViolation", null, piLog.getProcessInstanceId().longValue());
                    ++processSignals;
                }
                catch (Exception e) {
                    logger.warn("Unexpected error when signalig process instance {} about SLA violation {}", new Object[]{piLog.getProcessInstanceId(), e.getMessage(), e});
                }
                finally {
                    runtimeManager.disposeRuntimeEngine(engine);
                }
            }
            logger.info("SLA Violations JOB :: Number of process instances successfully signaled is {}", (Object)processSignals);
            executionResults.setData("ProcessSLASignals", (Object)processSignals);
        }
        return executionResults;
    }
}

