/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.document.marshalling;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.drools.core.common.DroolsObjectInputStream;
import org.jbpm.document.Document;
import org.jbpm.document.Documents;
import org.jbpm.document.marshalling.DocumentMarshallingStrategy;
import org.kie.api.marshalling.ObjectMarshallingStrategy;

public class DocumentsMarshallingStrategy
implements ObjectMarshallingStrategy {
    private DocumentMarshallingStrategy docMarshallingStrategy;

    public DocumentsMarshallingStrategy(DocumentMarshallingStrategy docMarshallingStrategy) {
        this.docMarshallingStrategy = docMarshallingStrategy;
    }

    public boolean accept(Object o) {
        return o instanceof Documents;
    }

    public byte[] marshal(ObjectMarshallingStrategy.Context ctx, ObjectOutputStream objectOutputStream, Object o) throws IOException {
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(buff);){
            Documents documents = (Documents)o;
            oos.writeInt(documents.getDocuments().size());
            for (Document nextDocument : documents.getDocuments()) {
                byte[] nextMarshalledDocument = this.docMarshallingStrategy.marshal(ctx, objectOutputStream, nextDocument);
                oos.writeInt(nextMarshalledDocument.length);
                oos.write(nextMarshalledDocument);
                oos.reset();
            }
        }
        return buff.toByteArray();
    }

    public Object unmarshal(ObjectMarshallingStrategy.Context ctx, ObjectInputStream objectInputStream, byte[] object, ClassLoader classLoader) throws IOException, ClassNotFoundException {
        Documents documents = new Documents();
        try (DroolsObjectInputStream is = new DroolsObjectInputStream((InputStream)new ByteArrayInputStream(object), classLoader);){
            int size = is.readInt();
            for (int i = 0; i < size; ++i) {
                int length = is.readInt();
                byte[] marshalledDocument = new byte[length];
                is.readFully(marshalledDocument);
                Document nextDocument = (Document)this.docMarshallingStrategy.unmarshal(ctx, objectInputStream, marshalledDocument, classLoader);
                documents.addDocument(nextDocument);
            }
        }
        return documents;
    }

    public Object read(ObjectInputStream arg0) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException("This marshalling strategy supports jBPM 6.5 and higher.");
    }

    public void write(ObjectOutputStream arg0, Object arg1) throws IOException {
        throw new UnsupportedOperationException("This marshalling strategy supports jBPM 6.5 and higher.");
    }

    public ObjectMarshallingStrategy.Context createContext() {
        return null;
    }
}

