/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.maven;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.jacoco.maven.AbstractReportMojo;
import org.jacoco.maven.FileFilter;
import org.jacoco.maven.ReportSupport;
import org.jacoco.report.IReportGroupVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="report-aggregate", threadSafe=true)
public class ReportAggregateMojo
extends AbstractReportMojo {
    @Parameter
    List<String> dataFileIncludes;
    @Parameter
    List<String> dataFileExcludes;
    @Parameter(defaultValue="${project.reporting.outputDirectory}/jacoco-aggregate")
    private File outputDirectory;
    @Parameter(property="reactorProjects", readonly=true)
    private List<MavenProject> reactorProjects;

    @Override
    boolean canGenerateReportRegardingDataFiles() {
        return true;
    }

    @Override
    boolean canGenerateReportRegardingClassesDirectory() {
        return true;
    }

    @Override
    void loadExecutionData(ReportSupport support) throws IOException {
        if (this.dataFileIncludes == null) {
            this.dataFileIncludes = Arrays.asList("target/*.exec");
        }
        FileFilter filter = new FileFilter(this.dataFileIncludes, this.dataFileExcludes);
        this.loadExecutionData(support, filter, this.getProject().getBasedir());
        for (MavenProject dependency : this.findDependencies("compile", "test")) {
            this.loadExecutionData(support, filter, dependency.getBasedir());
        }
    }

    private void loadExecutionData(ReportSupport support, FileFilter filter, File basedir) throws IOException {
        for (File execFile : filter.getFiles(basedir)) {
            support.loadExecutionData(execFile);
        }
    }

    @Override
    void addFormatters(ReportSupport support, Locale locale) throws IOException {
        support.addAllFormatters(this.outputDirectory, this.outputEncoding, this.footer, locale);
    }

    @Override
    void createReport(IReportGroupVisitor visitor, ReportSupport support) throws IOException {
        IReportGroupVisitor group = visitor.visitGroup(this.title);
        for (MavenProject dependency : this.findDependencies("compile")) {
            support.processProject(group, dependency.getArtifactId(), dependency, this.getIncludes(), this.getExcludes(), this.sourceEncoding);
        }
    }

    protected String getOutputDirectory() {
        return this.outputDirectory.getAbsolutePath();
    }

    public void setReportOutputDirectory(File reportOutputDirectory) {
        this.outputDirectory = reportOutputDirectory != null && !reportOutputDirectory.getAbsolutePath().endsWith("jacoco-aggregate") ? new File(reportOutputDirectory, "jacoco-aggregate") : reportOutputDirectory;
    }

    public String getOutputName() {
        return "jacoco-aggregate/index";
    }

    public String getName(Locale locale) {
        return "JaCoCo Aggregate";
    }

    private List<MavenProject> findDependencies(String ... scopes) {
        ArrayList<MavenProject> result = new ArrayList<MavenProject>();
        List<String> scopeList = Arrays.asList(scopes);
        for (Object dependencyObject : this.getProject().getDependencies()) {
            MavenProject project;
            Dependency dependency = (Dependency)dependencyObject;
            if (!scopeList.contains(dependency.getScope()) || (project = this.findProjectFromReactor(dependency)) == null) continue;
            result.add(project);
        }
        return result;
    }

    private MavenProject findProjectFromReactor(Dependency d) {
        for (MavenProject p : this.reactorProjects) {
            if (!p.getGroupId().equals(d.getGroupId()) || !p.getArtifactId().equals(d.getArtifactId()) || !p.getVersion().equals(d.getVersion())) continue;
            return p;
        }
        return null;
    }
}

