/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration;

import java.util.ArrayList;
import java.util.List;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.server.configuration.Element;
import org.infinispan.server.configuration.SocketBindingConfiguration;

public class SocketBindingsConfiguration
implements ConfigurationInfo {
    static final AttributeDefinition<Integer> PORT_OFFSET = AttributeDefinition.builder((String)"portOffset", null, Integer.class).build();
    static final AttributeDefinition<String> DEFAULT_INTERFACE = AttributeDefinition.builder((String)"defaultInterface", null, String.class).build();
    private static final ElementDefinition ELEMENT_DEFINITION = new DefaultElementDefinition(Element.SOCKET_BINDINGS.toString());
    private final List<SocketBindingConfiguration> socketBindings;
    private final List<ConfigurationInfo> configs = new ArrayList<ConfigurationInfo>();
    private final AttributeSet attributes;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(SocketBindingsConfiguration.class, new AttributeDefinition[]{PORT_OFFSET, DEFAULT_INTERFACE});
    }

    SocketBindingsConfiguration(AttributeSet attributes, List<SocketBindingConfiguration> socketBindings) {
        this.attributes = attributes.checkProtection();
        this.socketBindings = socketBindings;
        this.configs.addAll(socketBindings);
    }

    public List<ConfigurationInfo> subElements() {
        return this.configs;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public Integer offset() {
        return (Integer)this.attributes.attribute(PORT_OFFSET).get();
    }

    List<SocketBindingConfiguration> socketBindings() {
        return this.socketBindings;
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SocketBindingsConfiguration that = (SocketBindingsConfiguration)o;
        return this.attributes.equals((Object)that.attributes);
    }

    public int hashCode() {
        return this.attributes.hashCode();
    }

    public String toString() {
        return "SocketBindingConfiguration{attributes=" + this.attributes + '}';
    }
}

