/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.utils;

import com.icesoft.faces.context.DOMContext;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class AddResource {
    private static final int TEXT_NODE_TYPE = 3;
    private static final String LINK_ELM = "link";

    private AddResource() {
    }

    public static void addJavaScriptToNode(Node parentNode, String resourceDirectory, String scriptFileName, DOMContext domContext) {
        Element jsElement = null;
        List scripts = DOMContext.findChildrenWithNodeName((Element)((Element)parentNode), (String)"script");
        Iterator scriptIterator = scripts.iterator();
        while (scriptIterator.hasNext()) {
            Element next = (Element)scriptIterator.next();
            if (!next.getAttribute("src").equalsIgnoreCase(resourceDirectory + scriptFileName)) continue;
            jsElement = next;
        }
        if (jsElement == null) {
            jsElement = domContext.getDocument().createElement("script");
            jsElement.setAttribute("src", resourceDirectory + scriptFileName);
            jsElement.setAttribute("language", "javascript");
            parentNode.appendChild(jsElement);
        }
    }

    public static void addJavaScriptToHead(String resourceDirectory, String scriptFileName, DOMContext domContext) {
        Document test = domContext.getDocument();
        NodeList heads = test.getElementsByTagName("head");
        Node headNode = null;
        if (heads.getLength() > 0) {
            headNode = heads.item(0);
        } else {
            Element head = domContext.createElement("head");
            test.appendChild(head);
            headNode = head;
        }
        AddResource.addJavaScriptToNode(headNode, resourceDirectory, scriptFileName, domContext);
    }

    public static void addStyleSheetToHead(String resourceDirectory, String cssFileName, DOMContext domContext) {
        Document test = domContext.getDocument();
        NodeList heads = test.getElementsByTagName("head");
        Node headNode = heads.item(0);
        Element styleElement = null;
        List links = DOMContext.findChildrenWithNodeName((Element)((Element)headNode), (String)LINK_ELM);
        Iterator linkIterator = links.iterator();
        while (linkIterator.hasNext()) {
            Element next = (Element)linkIterator.next();
            if (!next.getAttribute("href").equalsIgnoreCase(resourceDirectory + cssFileName)) continue;
            styleElement = next;
        }
        if (styleElement == null) {
            styleElement = domContext.getDocument().createElement(LINK_ELM);
            styleElement.setAttribute("href", resourceDirectory + cssFileName);
            styleElement.setAttribute("type", "text/css");
            styleElement.setAttribute("rel", "stylesheet");
            headNode.appendChild(styleElement);
        }
    }

    public static void addInlineStyleToHead(String inlineStyle, DOMContext domContext) {
        Document test = domContext.getDocument();
        NodeList heads = test.getElementsByTagName("head");
        Node headNode = heads.item(0);
        Element styleElement = null;
        List styles = DOMContext.findChildrenWithNodeName((Element)((Element)headNode), (String)"style");
        Iterator styleIterator = styles.iterator();
        while (styleIterator.hasNext()) {
            Text styleText;
            Element next = (Element)styleIterator.next();
            if (!next.hasChildNodes() || next.getFirstChild().getNodeType() != 3 || !(styleText = (Text)next.getFirstChild()).getNodeValue().equalsIgnoreCase(inlineStyle)) continue;
            styleElement = next;
        }
        if (styleElement == null) {
            styleElement = domContext.getDocument().createElement("style");
            styleElement.setAttribute("type", "text/css");
            styleElement.setAttribute("rel", "stylesheet");
            Text inlineText = domContext.createTextNode(inlineStyle);
            styleElement.appendChild(inlineText);
            headNode.appendChild(styleElement);
        }
    }
}

