/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.ext;

import com.icesoft.faces.component.ext.HtmlDataTable;
import com.icesoft.faces.component.ext.RowSelectorActionEvent;
import com.icesoft.faces.component.ext.RowSelectorEvent;
import com.icesoft.faces.component.ext.UIColumns;
import com.icesoft.faces.component.ext.renderkit.TableRenderer;
import com.icesoft.faces.component.ext.taglib.Util;
import com.icesoft.faces.context.effects.JavascriptContext;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.faces.FacesException;
import javax.faces.application.NavigationHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIPanel;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.el.MethodNotFoundException;
import javax.faces.el.ValueBinding;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;

public class RowSelector
extends UIPanel {
    private Boolean value;
    private Boolean toggleOnClick;
    private Boolean toggleOnInput;
    private Boolean multiple;
    private String mouseOverClass;
    private String selectedClass;
    private String selectedMouseOverClass;
    private MethodBinding selectionListener;
    private MethodBinding selectionAction;
    private Integer clickedRow;
    private Boolean immediate;
    public static final String COMPONENT_TYPE = "com.icesoft.faces.RowSelector";
    public static final String COMPONENT_FAMILY = "com.icesoft.faces.RowSelectorFamily";
    String styleClass;

    public RowSelector() {
        JavascriptContext.includeLib((String)JavascriptContext.ICE_EXTRAS, (FacesContext)this.getFacesContext());
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public Boolean getValue() {
        ValueBinding vb = this.getValueBinding("value");
        if (vb != null) {
            return (Boolean)vb.getValue(this.getFacesContext());
        }
        if (this.value != null) {
            return this.value;
        }
        return Boolean.FALSE;
    }

    public void setValue(Boolean value) {
        ValueBinding vb = this.getValueBinding("value");
        if (vb != null) {
            vb.setValue(this.getFacesContext(), (Object)value);
        } else {
            this.value = value;
        }
    }

    public Integer getClickedRow() {
        ValueBinding vb = this.getValueBinding("clickedRow");
        if (vb != null) {
            return (Integer)vb.getValue(this.getFacesContext());
        }
        if (this.clickedRow != null) {
            return this.clickedRow;
        }
        return new Integer(-1);
    }

    public void setClickedRow(Integer clickedRow) {
        ValueBinding vb = this.getValueBinding("clickedRow");
        if (vb != null) {
            vb.setValue(this.getFacesContext(), (Object)clickedRow);
        } else {
            this.clickedRow = clickedRow;
        }
    }

    public Boolean getMultiple() {
        ValueBinding vb = this.getValueBinding("multiple");
        if (vb != null) {
            return (Boolean)vb.getValue(this.getFacesContext());
        }
        if (this.multiple != null) {
            return this.multiple;
        }
        return Boolean.FALSE;
    }

    public void setMultiple(Boolean multiple) {
        this.multiple = multiple;
    }

    public Boolean getToggleOnClick() {
        ValueBinding vb = this.getValueBinding("toggleOnClick");
        if (vb != null) {
            return (Boolean)vb.getValue(this.getFacesContext());
        }
        if (this.toggleOnClick != null) {
            return this.toggleOnClick;
        }
        return Boolean.TRUE;
    }

    public void setToggleOnClick(Boolean toggleOnClick) {
        this.toggleOnClick = toggleOnClick;
    }

    public Boolean getToggleOnInput() {
        ValueBinding vb = this.getValueBinding("toggleOnInput");
        if (vb != null) {
            return (Boolean)vb.getValue(this.getFacesContext());
        }
        if (this.toggleOnInput != null) {
            return this.toggleOnInput;
        }
        return Boolean.TRUE;
    }

    public void setToggleOnInput(Boolean toggleOnInput) {
        this.toggleOnInput = toggleOnInput;
    }

    public String getMouseOverClass() {
        return Util.getQualifiedStyleClass((UIComponent)this, this.mouseOverClass, "MouseOver", "mouseOverClass");
    }

    public void setMouseOverClass(String mouseOverClass) {
        this.mouseOverClass = mouseOverClass;
    }

    public String getSelectedClass() {
        return Util.getQualifiedStyleClass((UIComponent)this, this.selectedClass, "Selected", "selectedClass");
    }

    public void setSelectedClass(String selectedClass) {
        this.selectedClass = selectedClass;
    }

    public String getSelectedMouseOverClass() {
        return Util.getQualifiedStyleClass((UIComponent)this, this.selectedMouseOverClass, "SelectedMouseOver", "selectedMouseOverClass");
    }

    public void setSelectedMouseOverClass(String selectedMouseOverClass) {
        this.selectedMouseOverClass = selectedMouseOverClass;
    }

    public MethodBinding getSelectionListener() {
        return this.selectionListener;
    }

    public void setSelectionListener(MethodBinding selectionListener) {
        this.selectionListener = selectionListener;
    }

    public MethodBinding getSelectionAction() {
        return this.selectionAction;
    }

    public void setSelectionAction(MethodBinding selectionListener) {
        this.selectionAction = selectionListener;
    }

    public Boolean getImmediate() {
        if (this.immediate != null) {
            return this.immediate;
        }
        ValueBinding vb = this.getValueBinding("immediate");
        if (vb != null) {
            return (Boolean)vb.getValue(this.getFacesContext());
        }
        return Boolean.TRUE;
    }

    public void setImmediate(Boolean immediate) {
        this.immediate = immediate;
    }

    public void processDecodes(FacesContext facesContext) {
        HtmlDataTable dataTable = RowSelector.getParentDataTable((UIComponent)this);
        String dataTableId = dataTable.getClientId(facesContext);
        String selectedRowsParameter = TableRenderer.getSelectedRowParameterName(dataTableId);
        String selectedRows = (String)facesContext.getExternalContext().getRequestParameterMap().get(selectedRowsParameter);
        if (selectedRows == null || selectedRows.trim().length() == 0) {
            return;
        }
        int rowIndex = dataTable.getRowIndex();
        StringTokenizer st = new StringTokenizer(selectedRows, ",");
        boolean rowClicked = false;
        while (st.hasMoreTokens()) {
            int row = Integer.parseInt(st.nextToken());
            if (row != rowIndex) continue;
            if (this.getParent() instanceof UIColumns) {
                Object servedRow = this.getParent().getAttributes().get("rowServed");
                if (servedRow != null) {
                    if (String.valueOf(servedRow).equals(String.valueOf(rowIndex))) {
                        return;
                    }
                } else {
                    this.getParent().getAttributes().put("rowServed", String.valueOf(rowIndex));
                }
            }
            rowClicked = true;
            break;
        }
        RowSelector rowSelector = this;
        try {
            if (rowClicked) {
                Object evt;
                boolean b = rowSelector.getValue();
                b = !b;
                rowSelector.setValue(new Boolean(b));
                this.setClickedRow(new Integer(rowIndex));
                if (rowSelector.getSelectionListener() != null) {
                    evt = new RowSelectorEvent((UIComponent)rowSelector, rowIndex, b);
                    if (this.getImmediate().booleanValue()) {
                        evt.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
                    } else {
                        evt.setPhaseId(PhaseId.INVOKE_APPLICATION);
                    }
                    rowSelector.queueEvent((FacesEvent)evt);
                }
                if (rowSelector.getSelectionAction() != null) {
                    evt = new RowSelectorActionEvent((UIComponent)this);
                    if (this.getImmediate().booleanValue()) {
                        evt.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
                    } else {
                        evt.setPhaseId(PhaseId.INVOKE_APPLICATION);
                    }
                    rowSelector.queueEvent((FacesEvent)evt);
                }
                if (!this.getMultiple().booleanValue()) {
                    for (int i = 0; i < dataTable.getRowCount(); ++i) {
                        if (i == rowIndex) continue;
                        dataTable.setRowIndex(i);
                        this.setValue(Boolean.FALSE);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static HtmlDataTable getParentDataTable(UIComponent uiComponenent) {
        UIComponent parentComp = uiComponenent.getParent();
        if (parentComp == null) {
            throw new RuntimeException("RowSelectorRenderer: decode. Could not find an Ice:dataTable as a parent componenent");
        }
        if (parentComp instanceof HtmlDataTable) {
            return (HtmlDataTable)parentComp;
        }
        return RowSelector.getParentDataTable(parentComp);
    }

    public void encodeEnd(FacesContext facesContext) throws IOException {
    }

    public void encodeBegin(FacesContext facesContext) throws IOException {
    }

    public void broadcast(FacesEvent event) {
        super.broadcast(event);
        if (event instanceof RowSelectorEvent && this.selectionListener != null) {
            this.selectionListener.invoke(this.getFacesContext(), new Object[]{(RowSelectorEvent)event});
        }
        if (event instanceof RowSelectorActionEvent && this.selectionAction != null) {
            try {
                FacesContext facesContext = this.getFacesContext();
                Object result = this.selectionAction.invoke(facesContext, null);
                String outcome = result != null ? result.toString() : null;
                NavigationHandler nh = facesContext.getApplication().getNavigationHandler();
                nh.handleNavigation(facesContext, this.selectionAction.getExpressionString(), outcome);
                facesContext.renderResponse();
            }
            catch (MethodNotFoundException e) {
                throw new FacesException(this.selectionAction.getExpressionString() + ": " + e.getMessage(), (Throwable)e);
            }
            catch (EvaluationException e) {
                throw new FacesException(this.selectionAction.getExpressionString() + ": " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public Object saveState(FacesContext context) {
        Object[] state = new Object[]{super.saveState(context), this.value, this.multiple, this.toggleOnClick, this.toggleOnInput, this.clickedRow, this.mouseOverClass, this.selectedClass, this.selectedMouseOverClass, RowSelector.saveAttachedState((FacesContext)context, (Object)this.selectionListener), RowSelector.saveAttachedState((FacesContext)context, (Object)this.selectionAction)};
        return state;
    }

    public void restoreState(FacesContext context, Object stateIn) {
        Object[] state = (Object[])stateIn;
        super.restoreState(context, state[0]);
        this.value = (Boolean)state[1];
        this.multiple = (Boolean)state[2];
        this.toggleOnClick = (Boolean)state[3];
        this.toggleOnInput = (Boolean)state[4];
        this.clickedRow = (Integer)state[5];
        this.mouseOverClass = (String)state[6];
        this.selectedClass = (String)state[7];
        this.selectedMouseOverClass = (String)state[8];
        this.selectionListener = (MethodBinding)RowSelector.restoreAttachedState((FacesContext)context, (Object)state[9]);
        this.selectionAction = (MethodBinding)RowSelector.restoreAttachedState((FacesContext)context, (Object)state[10]);
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public String getStyleClass() {
        return Util.getQualifiedStyleClass((UIComponent)this, this.styleClass, "iceRowSel", "styleClass");
    }
}

