/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.gmap;

import com.icesoft.faces.component.gmap.GMap;
import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicRenderer;
import java.io.IOException;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.w3c.dom.Element;

public class GMapRenderer
extends DomBasicRenderer {
    public boolean getRendersChildren() {
        return true;
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        String clientId = uiComponent.getClientId(facesContext);
        GMap gmap = (GMap)uiComponent;
        DOMContext domContext = DOMContext.attachDOMContext((FacesContext)facesContext, (UIComponent)uiComponent);
        if (!domContext.isInitialized()) {
            Element container = domContext.createRootElement("table");
            container.setAttribute("class", gmap.getStyleClass());
            if (gmap.getStyle() != null) {
                container.setAttribute("style", gmap.getStyle());
            }
            Element tr = domContext.createElement("tr");
            Element td = domContext.createElement("td");
            td.setAttribute("class", gmap.getMapTdStyleClass());
            container.appendChild(tr);
            tr.appendChild(td);
            Element gmapDiv = domContext.createElement("div");
            td.appendChild(gmapDiv);
            gmapDiv.setAttribute("id", gmap.getClientId(facesContext));
            gmapDiv.setAttribute("class", "gmap");
            this.addHiddenField(domContext, td, clientId, "hdn");
            this.addHiddenField(domContext, td, clientId, "lat");
            this.addHiddenField(domContext, td, clientId, "lng");
            this.addHiddenField(domContext, td, clientId, "zoom");
            this.addHiddenField(domContext, td, clientId, "type", gmap.getType());
            this.addHiddenField(domContext, td, clientId, "event");
        }
        domContext.stepOver();
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        Iterator kids = component.getChildren().iterator();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            kid.encodeBegin(context);
            if (kid.getRendersChildren()) {
                kid.encodeChildren(context);
            }
            kid.encodeEnd(context);
        }
    }

    private void addHiddenField(DOMContext domContext, Element td, String clientId, String name) {
        this.addHiddenField(domContext, td, clientId, name, null);
    }

    private void addHiddenField(DOMContext domContext, Element td, String clientId, String name, String value) {
        Element hidden = domContext.createElement("input");
        hidden.setAttribute("id", clientId + name);
        hidden.setAttribute("name", clientId + name);
        if (value != null) {
            hidden.setAttribute("value", value);
        }
        hidden.setAttribute("type", "hidden");
        td.appendChild(hidden);
    }
}

