/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javassist.util.proxy.MethodFilter;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.NormalScope;
import javax.enterprise.inject.Stereotype;
import javax.enterprise.inject.UnproxyableResolutionException;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Scope;
import javax.inject.Singleton;
import javax.servlet.ServletContext;
import org.exoplatform.commons.utils.ClassLoading;
import org.exoplatform.commons.utils.PropertiesLoader;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.commons.utils.Tools;
import org.exoplatform.container.ContainerLifecyclePlugin;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.context.DefinitionException;
import org.exoplatform.container.xml.Component;
import org.exoplatform.container.xml.ComponentLifecyclePlugin;
import org.exoplatform.container.xml.Deserializer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerUtil {
    private static final Log LOG = ExoLogger.getExoLogger(ContainerUtil.class);
    private static final Comparator<Constructor<?>> CONSTRUCTOR_COMPARATOR = new Comparator<Constructor<?>>(){

        @Override
        public int compare(Constructor<?> o1, Constructor<?> o2) {
            return o2.getParameterTypes().length - o1.getParameterTypes().length;
        }
    };

    public static Constructor<?>[] getSortedConstructors(Class<?> clazz) throws NoClassDefFoundError {
        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            Constructor<?> c = constructors[i];
            if (!c.isAnnotationPresent(Inject.class)) continue;
            return new Constructor[]{c};
        }
        constructors = clazz.getConstructors();
        Arrays.sort(constructors, CONSTRUCTOR_COMPARATOR);
        return constructors;
    }

    public static boolean hasInjectableConstructor(Class<?> clazz) {
        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            Constructor<?> c = constructors[i];
            if (!c.isAnnotationPresent(Inject.class)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasOnlyEmptyPublicConstructor(Class<?> clazz) {
        Constructor<?>[] constructors = clazz.getConstructors();
        return constructors.length == 1 && constructors[0].getParameterTypes().length == 0 && Modifier.isPublic(constructors[0].getModifiers());
    }

    public static boolean hasFieldOrMethodWithInject(Class<?> clazz) {
        if (clazz == null || clazz.equals(Object.class)) {
            return false;
        }
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].isAnnotationPresent(Inject.class)) continue;
            return true;
        }
        Method[] methods = clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].isAnnotationPresent(Inject.class)) continue;
            return true;
        }
        return ContainerUtil.hasFieldOrMethodWithInject(clazz.getSuperclass());
    }

    public static Class<? extends Annotation> getScope(Class<?> clazz) throws DefinitionException {
        return ContainerUtil.getScope(clazz, false);
    }

    public static Class<? extends Annotation> getScope(Class<?> clazz, boolean ignoreExplicit) throws DefinitionException {
        Annotation[] annotations = clazz.getAnnotations();
        Class<? extends Annotation> scope = null;
        Class<? extends Annotation> defaultScope = null;
        boolean hasStereotype = false;
        for (int i = 0; i < annotations.length; ++i) {
            Annotation annotation = annotations[i];
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (!ignoreExplicit && (annotationType.isAnnotationPresent(Scope.class) || annotationType.isAnnotationPresent(NormalScope.class))) {
                if (scope != null) {
                    throw new DefinitionException("You cannot set several scopes to the class " + clazz.getName());
                }
                scope = annotationType;
                continue;
            }
            if (!annotationType.isAnnotationPresent(Stereotype.class)) continue;
            hasStereotype = true;
            Annotation[] stereotypeAnnotations = annotationType.getAnnotations();
            for (int j = 0; j < stereotypeAnnotations.length; ++j) {
                Annotation stereotypeAnnotation = stereotypeAnnotations[j];
                Class<? extends Annotation> stereotypeAnnotationType = stereotypeAnnotation.annotationType();
                if (!stereotypeAnnotationType.isAnnotationPresent(Scope.class) && !stereotypeAnnotationType.isAnnotationPresent(NormalScope.class)) continue;
                if (defaultScope != null && !defaultScope.equals(stereotypeAnnotationType)) {
                    throw new DefinitionException("The class " + clazz.getName() + " has stereotypes with different default scope");
                }
                defaultScope = stereotypeAnnotationType;
            }
        }
        if (scope != null) {
            return scope;
        }
        if (defaultScope != null) {
            return defaultScope;
        }
        if (hasStereotype) {
            throw new DefinitionException("The class " + clazz.getName() + " has at least one stereotype but doesn't have any scope, please set an explicit scope");
        }
        return null;
    }

    public static boolean isSingleton(Class<?> clazz) {
        Class<? extends Annotation> scope = ContainerUtil.getScope(clazz);
        if (scope != null) {
            return scope.equals(Singleton.class) || scope.equals(ApplicationScoped.class);
        }
        boolean hasInjectableConstructor = ContainerUtil.hasInjectableConstructor(clazz);
        boolean hasOnlyEmptyPublicConstructor = ContainerUtil.hasOnlyEmptyPublicConstructor(clazz);
        if (!hasInjectableConstructor && !hasOnlyEmptyPublicConstructor) {
            return true;
        }
        if (hasInjectableConstructor) {
            return clazz.isAnnotationPresent(Singleton.class);
        }
        if (ContainerUtil.hasFieldOrMethodWithInject(clazz)) {
            return clazz.isAnnotationPresent(Singleton.class);
        }
        return true;
    }

    public static Collection<URL> getConfigurationURL(final String configuration) throws Exception {
        final ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Collection c = (Collection)SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Collection>(){

            @Override
            public Collection run() throws IOException {
                return Collections.list(cl.getResources(configuration));
            }
        });
        HashMap<String, URL> map = new HashMap<String, URL>();
        Iterator<Object> i = c.iterator();
        String forbiddenSuffix = "WEB-INF/" + configuration;
        while (i.hasNext()) {
            int index2;
            int index;
            URL url = (URL)i.next();
            String key = url.toString();
            if (key.endsWith(forbiddenSuffix)) continue;
            int index1 = key.lastIndexOf("exo-");
            int n = index = index1 < (index2 = key.lastIndexOf("exo.")) ? index2 : index1;
            if (index >= 0) {
                key = key.substring(index);
            }
            map.put(key, url);
        }
        i = map.values().iterator();
        return map.values();
    }

    public static void addContainerLifecyclePlugin(ExoContainer container, ConfigurationManager conf) {
        Iterator<org.exoplatform.container.xml.ContainerLifecyclePlugin> i = conf.getConfiguration().getContainerLifecyclePluginIterator();
        while (i.hasNext()) {
            org.exoplatform.container.xml.ContainerLifecyclePlugin plugin = i.next();
            ContainerUtil.addContainerLifecyclePlugin(container, plugin);
        }
    }

    private static void addContainerLifecyclePlugin(ExoContainer container, org.exoplatform.container.xml.ContainerLifecyclePlugin plugin) {
        try {
            Class clazz = ClassLoading.forName((String)plugin.getType(), ContainerUtil.class);
            ContainerLifecyclePlugin cplugin = (ContainerLifecyclePlugin)container.createComponent(clazz, plugin.getInitParams());
            cplugin.setName(plugin.getName());
            cplugin.setDescription(plugin.getDescription());
            container.addContainerLifecylePlugin(cplugin);
        }
        catch (Exception ex) {
            LOG.error((Object)("Failed to instanciate plugin " + plugin.getType() + ": " + ex.getMessage()), (Throwable)ex);
        }
    }

    public static void addComponentLifecyclePlugin(ExoContainer container, ConfigurationManager conf) {
        Collection<ComponentLifecyclePlugin> plugins = conf.getConfiguration().getComponentLifecyclePlugins();
        for (ComponentLifecyclePlugin plugin : plugins) {
            try {
                Class classType = ClassLoading.loadClass((String)plugin.getType(), ContainerUtil.class);
                org.exoplatform.container.component.ComponentLifecyclePlugin instance = (org.exoplatform.container.component.ComponentLifecyclePlugin)classType.newInstance();
                container.addComponentLifecylePlugin(instance);
            }
            catch (Exception ex) {
                LOG.error((Object)("Failed to instanciate plugin " + plugin.getType() + ": " + ex.getMessage()), (Throwable)ex);
            }
        }
    }

    public static void addComponents(ExoContainer container, ConfigurationManager conf) {
        Collection<Component> components = conf.getComponents();
        if (components == null) {
            return;
        }
        for (Component component : components) {
            String type = component.getType();
            String key = component.getKey();
            try {
                Class classType = ClassLoading.loadClass((String)type, ContainerUtil.class);
                if (key == null) {
                    if (component.isMultiInstance()) {
                        throw new UnsupportedOperationException("Multi-instance isn't allowed anymore");
                    }
                    container.registerComponentImplementation(classType);
                    continue;
                }
                try {
                    Class keyType = ClassLoading.loadClass((String)key, ContainerUtil.class);
                    if (component.isMultiInstance()) {
                        throw new UnsupportedOperationException("Multi-instance isn't allowed anymore");
                    }
                    container.registerComponentImplementation(keyType, classType);
                }
                catch (Exception ex) {
                    container.registerComponentImplementation(key, classType);
                }
            }
            catch (ClassNotFoundException ex) {
                LOG.error((Object)("Cannot register the component corresponding to key = '" + key + "' and type = '" + type + "'"), (Throwable)ex);
            }
        }
    }

    public static Map<String, String> loadProperties(URL url) {
        return ContainerUtil.loadProperties(url, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> loadProperties(URL url, boolean resolveVariables) {
        LinkedHashMap props = null;
        String path = null;
        InputStream in = null;
        try {
            if (url != null) {
                path = url.getPath();
                in = url.openStream();
            }
            if (in != null) {
                String fileName = url.getFile();
                if (Tools.endsWithIgnoreCase((String)path, (String)".properties")) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Attempt to load property file " + path));
                    }
                    props = PropertiesLoader.load((InputStream)in);
                } else if (Tools.endsWithIgnoreCase((String)fileName, (String)".xml")) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Attempt to load property file " + path + " with XML format"));
                    }
                    props = PropertiesLoader.loadFromXML((InputStream)in);
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Will not load property file" + path + " because its format is not recognized"));
                }
                if (props != null && resolveVariables) {
                    HashMap<String, Object> currentProps = new HashMap<String, Object>();
                    for (Map.Entry entry : props.entrySet()) {
                        String propertyName = (String)entry.getKey();
                        String propertyValue = (String)entry.getValue();
                        propertyValue = Deserializer.resolveVariables(propertyValue, currentProps);
                        props.put(propertyName, propertyValue);
                        currentProps.put(propertyName, propertyValue);
                    }
                }
            } else {
                LOG.error((Object)("Could not load property file " + path));
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Cannot load property file " + path), (Throwable)e);
        }
        finally {
            block25: {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ignore) {
                        if (!LOG.isTraceEnabled()) break block25;
                        LOG.trace((Object)("An exception occurred: " + ignore.getMessage()));
                    }
                }
            }
        }
        return props;
    }

    public static <T> T createProxy(final Class<T> superClass, final Provider<T> provider) throws UnproxyableResolutionException {
        PrivilegedExceptionAction action = new PrivilegedExceptionAction<T>(){

            @Override
            public T run() throws Exception {
                Method[] methods = superClass.getDeclaredMethods();
                for (int i = 0; i < methods.length; ++i) {
                    Method m = methods[i];
                    int modifiers = m.getModifiers();
                    if (!Modifier.isFinal(modifiers) || Modifier.isPrivate(modifiers) || Modifier.isStatic(modifiers)) continue;
                    throw new UnproxyableResolutionException("Cannot create a proxy for the class " + superClass.getName() + " because it has at least one non-static, final method with public, protected or default visibility");
                }
                try {
                    ProxyFactory factory = new ProxyFactory();
                    factory.setSuperclass(superClass);
                    factory.setFilter(MethodFilterHolder.METHOD_FILTER);
                    MethodHandler handler = new MethodHandler(){

                        public Object invoke(Object self, Method m, Method proceed, Object[] args) throws Throwable {
                            if (!(Modifier.isPublic(m.getModifiers()) && Modifier.isPublic(m.getDeclaringClass().getModifiers()) || m.isAccessible())) {
                                m.setAccessible(true);
                            }
                            return m.invoke(provider.get(), args);
                        }
                    };
                    return superClass.cast(factory.create(new Class[0], new Object[0], handler));
                }
                catch (Exception e) {
                    throw new UnproxyableResolutionException("Cannot create a proxy for the class " + superClass.getName(), (Throwable)e);
                }
            }
        };
        try {
            return (T)SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)action);
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof UnproxyableResolutionException) {
                throw (UnproxyableResolutionException)cause;
            }
            throw new UnproxyableResolutionException("Cannot create a proxy for the class " + superClass.getName(), cause);
        }
    }

    public static String getServletContextName(ServletContext context) {
        String result = context.getServletContextName();
        if (result == null) {
            int index;
            result = context.getContextPath();
            if (result == null) {
                return result;
            }
            if (result.startsWith("/")) {
                result = result.substring(1);
            }
            if ((index = result.indexOf(47)) >= 0) {
                result = result.substring(0, index);
            }
        }
        return result;
    }

    private static final class MethodFilterHolder {
        private static final MethodFilter METHOD_FILTER = new MethodFilter(){

            public boolean isHandled(Method method) {
                return !method.getDeclaringClass().equals(Object.class);
            }
        };

        private MethodFilterHolder() {
        }
    }
}

