/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.jmx;

import java.lang.reflect.Method;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import org.exoplatform.commons.utils.ClassLoading;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.component.ComponentLifecycle;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.ComponentPlugin;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.AbstractComponentAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MX4JComponentAdapter
extends AbstractComponentAdapter {
    private static final long serialVersionUID = -9001193588034229411L;
    private volatile Object instance_;
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.container.MX4JComponentAdapter");

    public MX4JComponentAdapter(Object key, Class<?> implementation) {
        super(key, implementation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Object getComponentInstance(PicoContainer container) {
        block17: {
            if (this.instance_ != null) {
                return this.instance_;
            }
            exocontainer = (ExoContainer)container;
            component = null;
            params = null;
            debug = false;
            var8_8 = this;
            // MONITORENTER : var8_8
            if (this.instance_ != null) {
                var9_9 = this.instance_;
                // MONITOREXIT : var8_8
                return var9_9;
            }
            ** try [egrp 2[TRYBLOCK] [5 : 57->157)] { 
lbl-1000:
            // 1 sources

            {
                key = this.getComponentKey();
                componentKey = key instanceof String != false ? (String)key : ((Class)key).getName();
                manager = (ConfigurationManager)exocontainer.getComponentInstanceOfType(ConfigurationManager.class);
                component = manager.getComponent(componentKey);
                if (component != null) {
                    params = component.getInitParams();
                    debug = component.getShowDeployInfo();
                }
                instance = exocontainer.createComponent(this.getComponentImplementation(), params);
                if (this.instance_ == null) break block17;
                var11_14 = this.instance_;
                // MONITOREXIT : var8_8
            }
            exocontainer.removeComponentFromCtx(this.getComponentKey());
            return var11_14;
        }
        try {
            exocontainer.addComponentToCtx(this.getComponentKey(), instance);
            if (debug) {
                MX4JComponentAdapter.LOG.debug((Object)("==> create  component : " + this.instance_));
            }
            if (component != null && component.getComponentPlugins() != null) {
                this.addComponentPlugin(debug, instance, component.getComponentPlugins(), exocontainer);
            }
            if ((ecplugins = manager.getConfiguration().getExternalComponentPlugins(componentKey)) != null) {
                this.addComponentPlugin(debug, instance, ecplugins.getComponentPlugins(), exocontainer);
            }
            if (instance instanceof ComponentLifecycle) {
                lc = (ComponentLifecycle)instance;
                lc.initComponent(exocontainer);
            }
            this.instance_ = instance;
            // MONITOREXIT : var8_8
        }
lbl44:
        // 3 sources

        catch (Exception ex) {
            msg = "Cannot instantiate component " + this.getComponentImplementation();
            if (component == null) throw new RuntimeException(msg, ex);
            msg = "Cannot instantiate component key=" + component.getKey() + " type=" + component.getType() + " found at " + component.getDocumentURL();
            throw new RuntimeException(msg, ex);
        }
        finally {
            exocontainer.removeComponentFromCtx(this.getComponentKey());
        }
        exocontainer.removeComponentFromCtx(this.getComponentKey());
        return this.instance_;
    }

    private void addComponentPlugin(boolean debug, final Object component, List<ComponentPlugin> plugins, ExoContainer container) throws Exception {
        if (plugins == null) {
            return;
        }
        for (ComponentPlugin plugin : plugins) {
            try {
                Class pluginClass = ClassLoading.forName((String)plugin.getType(), (Object)((Object)this));
                org.exoplatform.container.component.ComponentPlugin cplugin = (org.exoplatform.container.component.ComponentPlugin)container.createComponent(pluginClass, plugin.getInitParams());
                cplugin.setName(plugin.getName());
                cplugin.setDescription(plugin.getDescription());
                Class<?> clazz = component.getClass();
                final Method m = this.getSetMethod(clazz, plugin.getSetMethod(), pluginClass);
                if (m == null) {
                    LOG.error((Object)("Cannot find the method '" + plugin.getSetMethod() + "' that has only one parameter of type '" + pluginClass.getName() + "' in the class '" + clazz.getName() + "'."));
                    continue;
                }
                final Object[] params = new Object[]{cplugin};
                SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        m.invoke(component, params);
                        return null;
                    }
                });
                if (debug) {
                    LOG.debug((Object)("==> add component plugin: " + cplugin));
                }
                cplugin.setName(plugin.getName());
                cplugin.setDescription(plugin.getDescription());
            }
            catch (Exception ex) {
                LOG.error((Object)("Failed to instanciate plugin " + plugin.getName() + " for component " + component + ": " + ex.getMessage()), (Throwable)ex);
            }
        }
    }

    private Method getSetMethod(Class<?> clazz, String name, Class<?> pluginClass) {
        Method[] methods = clazz.getMethods();
        Method bestCandidate = null;
        int depth = -1;
        for (Method m : methods) {
            Class<?>[] types;
            if (!name.equals(m.getName()) || (types = m.getParameterTypes()) == null || types.length != 1 || !org.exoplatform.container.component.ComponentPlugin.class.isAssignableFrom(types[0]) || !types[0].isAssignableFrom(pluginClass)) continue;
            int currentDepth = MX4JComponentAdapter.getClosestMatchDepth(pluginClass, types[0]);
            if (currentDepth == 0) {
                return m;
            }
            if (depth != -1 && depth <= currentDepth) continue;
            bestCandidate = m;
            depth = currentDepth;
        }
        return bestCandidate;
    }

    private static int getClosestMatchDepth(Class<?> pluginClass, Class<?> type) {
        return MX4JComponentAdapter.getClosestMatchDepth(pluginClass, type, 0);
    }

    private static int getClosestMatchDepth(Class<?> pluginClass, Class<?> type, int depth) {
        if (pluginClass == null || pluginClass.isAssignableFrom(type)) {
            return depth;
        }
        return MX4JComponentAdapter.getClosestMatchDepth(pluginClass.getSuperclass(), type, depth + 1);
    }

    public void verify(PicoContainer container) {
    }
}

