/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container;

import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.WebAppInitContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PortalContainerContext
implements ServletContext {
    private volatile WeakReference<PortalContainer> containerRef;
    private final String portalContainerName;

    PortalContainerContext(PortalContainer container) {
        this.containerRef = new WeakReference<PortalContainer>(container);
        this.portalContainerName = container.getName();
    }

    private WebAppInitContext[] getWebAppInitContexts() {
        Set<WebAppInitContext> contexts = this.getPortalContainer().getWebAppInitContexts();
        WebAppInitContext[] aContexts = new WebAppInitContext[contexts.size()];
        return contexts.toArray(aContexts);
    }

    private PortalContainer getPortalContainer() {
        PortalContainer container = (PortalContainer)this.containerRef.get();
        if (container != null) {
            return container;
        }
        container = RootContainer.getInstance().getPortalContainer(this.portalContainerName);
        this.containerRef = new WeakReference<PortalContainer>(container);
        return container;
    }

    private ServletContext getPortalContext() {
        return this.getPortalContainer().portalContext;
    }

    public Object getAttribute(String name) {
        return this.getPortalContext().getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return this.getPortalContext().getAttributeNames();
    }

    public ServletContext getContext(String uripath) {
        return this.getPortalContext().getContext(uripath);
    }

    public String getInitParameter(String name) {
        WebAppInitContext[] contexts = this.getWebAppInitContexts();
        for (int i = contexts.length - 1; i >= 0; --i) {
            ServletContext context = contexts[i].getServletContext();
            String param = context.getInitParameter(name);
            if (param == null) continue;
            return param;
        }
        return null;
    }

    public Enumeration<String> getInitParameterNames() {
        Set<WebAppInitContext> contexts = this.getPortalContainer().getWebAppInitContexts();
        HashSet names = null;
        for (WebAppInitContext context : contexts) {
            Enumeration eNames = context.getServletContext().getAttributeNames();
            if (eNames == null) continue;
            if (names == null) {
                names = new HashSet();
            }
            names.addAll(Collections.list(eNames));
        }
        if (names == null) {
            return null;
        }
        return Collections.enumeration(names);
    }

    public int getMajorVersion() {
        return this.getPortalContext().getMajorVersion();
    }

    public String getMimeType(String file) {
        WebAppInitContext[] contexts = this.getWebAppInitContexts();
        for (int i = contexts.length - 1; i >= 0; --i) {
            ServletContext context = contexts[i].getServletContext();
            String mimeType = context.getMimeType(file);
            if (mimeType == null) continue;
            return mimeType;
        }
        return null;
    }

    public int getMinorVersion() {
        return this.getPortalContext().getMinorVersion();
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        return this.getPortalContext().getNamedDispatcher(name);
    }

    public String getRealPath(String path) {
        WebAppInitContext[] contexts = this.getWebAppInitContexts();
        for (int i = contexts.length - 1; i >= 0; --i) {
            ServletContext context = contexts[i].getServletContext();
            InputStream is = context.getResourceAsStream(path);
            if (is == null) continue;
            return context.getRealPath(path);
        }
        return null;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        WebAppInitContext[] contexts = this.getWebAppInitContexts();
        for (int i = contexts.length - 1; i >= 0; --i) {
            ServletContext context = contexts[i].getServletContext();
            InputStream is = context.getResourceAsStream(path);
            if (is == null) continue;
            return context.getRequestDispatcher(path);
        }
        return null;
    }

    public URL getResource(String path) throws MalformedURLException {
        WebAppInitContext[] contexts = this.getWebAppInitContexts();
        for (int i = contexts.length - 1; i >= 0; --i) {
            ServletContext context = contexts[i].getServletContext();
            URL url = context.getResource(path);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    public InputStream getResourceAsStream(String path) {
        WebAppInitContext[] contexts = this.getWebAppInitContexts();
        for (int i = contexts.length - 1; i >= 0; --i) {
            ServletContext context = contexts[i].getServletContext();
            InputStream is = context.getResourceAsStream(path);
            if (is == null) continue;
            return is;
        }
        return null;
    }

    public Set<String> getResourcePaths(String path) {
        Set<WebAppInitContext> contexts = this.getPortalContainer().getWebAppInitContexts();
        LinkedHashSet paths = null;
        for (WebAppInitContext context : contexts) {
            Set sPaths = context.getServletContext().getResourcePaths(path);
            if (sPaths == null) continue;
            if (paths == null) {
                paths = new LinkedHashSet();
            }
            paths.addAll(sPaths);
        }
        return paths;
    }

    public String getServerInfo() {
        return this.getPortalContext().getServerInfo();
    }

    public Servlet getServlet(String name) throws ServletException {
        return this.getPortalContext().getServlet(name);
    }

    public String getServletContextName() {
        return this.getPortalContext().getServletContextName();
    }

    public Enumeration getServletNames() {
        return this.getPortalContext().getServletNames();
    }

    public Enumeration getServlets() {
        return this.getPortalContext().getServlets();
    }

    public void log(String message) {
        this.getPortalContext().log(message);
    }

    public void log(Exception exception, String message) {
        this.getPortalContext().log(exception, message);
    }

    public void log(String message, Throwable throwable) {
        this.getPortalContext().log(message, throwable);
    }

    public void removeAttribute(String name) {
        this.getPortalContext().removeAttribute(name);
    }

    public void setAttribute(String name, Object object) {
        this.getPortalContext().setAttribute(name, object);
    }

    public String getContextPath() {
        return this.getPortalContext().getContextPath();
    }
}

