/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container;

import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.util.ContainerUtil;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.container.xml.Property;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

public class PropertyConfigurator
implements Startable {
    private final Log log = ExoLogger.getExoLogger(PropertyConfigurator.class);

    public PropertyConfigurator(ConfigurationManager confManager) {
        this(null, confManager);
    }

    public PropertyConfigurator(InitParams params, ConfigurationManager confManager) {
        String systemPath;
        String path = null;
        if (params != null) {
            ValueParam pathParam;
            PropertiesParam propertiesParam = params.getPropertiesParam("properties");
            if (propertiesParam != null) {
                this.log.debug((Object)"Going to initialize properties from init param");
                Iterator<Property> i = propertiesParam.getPropertyIterator();
                while (i.hasNext()) {
                    Property property = i.next();
                    String name = property.getName();
                    String value = property.getValue();
                    this.log.debug((Object)("Adding property from init param " + name + " = " + value));
                    PropertyManager.setProperty((String)name, (String)value);
                }
            }
            if ((pathParam = params.getValueParam("properties.url")) != null) {
                this.log.debug((Object)("Using file path " + path + " found from configuration"));
                path = pathParam.getValue();
            }
        }
        if ((systemPath = PropertyManager.getProperty((String)"exo.properties.url")) != null) {
            this.log.debug((Object)("Using file path " + path + " found from system properties"));
            path = systemPath;
        }
        if (path != null) {
            this.log.debug((Object)("Found property file path " + path));
            try {
                URL url = confManager.getURL(path);
                Map<String, String> props = ContainerUtil.loadProperties(url);
                if (props != null) {
                    for (Map.Entry<String, String> entry : props.entrySet()) {
                        String propertyName = entry.getKey();
                        String propertyValue = entry.getValue();
                        PropertyManager.setProperty((String)propertyName, (String)propertyValue);
                    }
                }
            }
            catch (Exception e) {
                this.log.error((Object)("Cannot load property file " + path), (Throwable)e);
            }
        }
    }

    public void start() {
    }

    public void stop() {
    }
}

