/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.management.spi;

import java.lang.reflect.Method;
import org.exoplatform.management.spi.ManagedMetaData;
import org.exoplatform.management.spi.ManagedParameterMetaData;

public class ManagedPropertyMetaData
extends ManagedMetaData {
    private final String name;
    private final Method getter;
    private final String getterDescription;
    private final Method setter;
    private final String setterDescription;
    private final ManagedParameterMetaData setterParameter;

    public ManagedPropertyMetaData(String name, Method getter, String getterDescription, Method setter, String setterDescription, ManagedParameterMetaData setterParameter) throws NullPointerException, IllegalArgumentException {
        if (name == null) {
            throw new NullPointerException("No null name accepted");
        }
        if (setter != null) {
            if (setterParameter == null) {
                throw new IllegalArgumentException("No setter parameter provided");
            }
        } else if (setterParameter != null) {
            throw new IllegalArgumentException("No setter provided but a setter parameter was provided");
        }
        this.name = name;
        this.getter = getter;
        this.getterDescription = getterDescription;
        this.setter = setter;
        this.setterDescription = setterDescription;
        this.setterParameter = setterParameter;
    }

    public String getName() {
        return this.name;
    }

    public Method getGetter() {
        return this.getter;
    }

    public Method getSetter() {
        return this.setter;
    }

    public String getGetterDescription() {
        return this.getterDescription;
    }

    public String getSetterDescription() {
        return this.setterDescription;
    }

    public ManagedParameterMetaData getSetterParameter() {
        return this.setterParameter;
    }

    public String toString() {
        return "ManagedPropertyMetaData[name=" + this.name + "getter=" + this.getter.getName() + "setter=" + this.setter.getName() + "]";
    }
}

