/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.command.impl;

import java.io.IOException;
import java.io.InputStream;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import org.apache.commons.chain.Catalog;
import org.apache.commons.chain.CatalogFactory;
import org.apache.commons.chain.config.ConfigParser;
import org.apache.commons.chain.impl.CatalogFactoryBase;
import org.apache.commons.digester.Digester;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.component.ComponentPlugin;
import org.xml.sax.SAXException;

public class CommandService {
    protected CatalogFactory catalogFactory = CatalogFactoryBase.getInstance();
    protected Digester digester;

    public CommandService() {
        final ConfigParser parser = new ConfigParser();
        this.digester = (Digester)SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Digester>(){

            @Override
            public Digester run() {
                return parser.getDigester();
            }
        });
    }

    public void addPlugin(ComponentPlugin plugin) {
    }

    public void putCatalog(final InputStream xml) throws IOException, SAXException {
        this.digester.clear();
        try {
            SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    CommandService.this.digester.parse(xml);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof SAXException) {
                throw (SAXException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public Catalog getCatalog() {
        Catalog catalog = this.catalogFactory.getCatalog();
        return catalog;
    }

    public Catalog getCatalog(String name) {
        Catalog catalog = this.catalogFactory.getCatalog(name);
        return catalog;
    }

    public Iterator getCatalogNames() {
        return this.catalogFactory.getNames();
    }
}

