/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.SecureRandom;

public class IdentifierUtil {
    private static String hexServerIP_ = null;
    private static final SecureRandom seeder_ = new SecureRandom();

    public static String generateUUID(Object o) {
        StringBuffer tmpBuffer = new StringBuffer(16);
        if (hexServerIP_ == null) {
            InetAddress localInetAddress = null;
            try {
                localInetAddress = InetAddress.getLocalHost();
            }
            catch (UnknownHostException uhe) {
                uhe.printStackTrace();
                return null;
            }
            byte[] serverIP = localInetAddress.getAddress();
            hexServerIP_ = IdentifierUtil.hexFormat(IdentifierUtil.getInt(serverIP), 8);
        }
        String hashcode = IdentifierUtil.hexFormat(System.identityHashCode(o), 8);
        tmpBuffer.append(hexServerIP_);
        tmpBuffer.append(hashcode);
        long timeNow = System.currentTimeMillis();
        int timeLow = (int)timeNow & 0xFFFFFFFF;
        int node = seeder_.nextInt();
        StringBuffer guid = new StringBuffer(32);
        guid.append(IdentifierUtil.hexFormat(timeLow, 8));
        guid.append(tmpBuffer.toString());
        guid.append(IdentifierUtil.hexFormat(node, 8));
        return guid.toString();
    }

    private static int getInt(byte[] bytes) {
        int i = 0;
        int j = 24;
        int k = 0;
        while (j >= 0) {
            int l = bytes[k] & 0xFF;
            i += l << j;
            j -= 8;
            ++k;
        }
        return i;
    }

    private static String hexFormat(int i, int j) {
        String s = Integer.toHexString(i);
        return IdentifierUtil.padHex(s, j) + s;
    }

    private static String padHex(String s, int i) {
        StringBuffer tmpBuffer = new StringBuffer();
        if (s.length() < i) {
            for (int j = 0; j < i - s.length(); ++j) {
                tmpBuffer.append('0');
            }
        }
        return tmpBuffer.toString();
    }
}

