/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document.v4;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.executor.PageVariable;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.internal.document.PageHintReader;
import org.eclipse.birt.report.engine.internal.document.v3.CachedReportContentReaderV3;
import org.eclipse.birt.report.engine.internal.document.v4.ContainerExecutor;
import org.eclipse.birt.report.engine.internal.document.v4.ExecutorManager;
import org.eclipse.birt.report.engine.internal.document.v4.PageBandExecutor;
import org.eclipse.birt.report.engine.internal.document.v4.ReportItemExecutor;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.engine.ir.SimpleMasterPageDesign;
import org.eclipse.birt.report.engine.presentation.IPageHint;

public class MasterPageExecutor
extends ContainerExecutor {
    private static final int HEADER_BAND = 0;
    private static final int BODY_BAND = 1;
    private static final int FOOTER_BAND = 2;
    private long pageNumber;
    private long pageOffset;
    private SimpleMasterPageDesign masterPage;
    private int nextBand;
    IBaseResultSet[] rs;

    protected MasterPageExecutor(ExecutorManager manager, long pageNumber, MasterPageDesign masterPage) {
        super(manager, -1);
        this.reader = manager.getPageReader();
        this.pageNumber = pageNumber;
        this.pageOffset = -1L;
        this.nextBand = 0;
        this.masterPage = (SimpleMasterPageDesign)masterPage;
    }

    public void close() {
        this.context.setExecutingMasterPage(false);
        this.context.setResultSets(this.rs);
        this.pageNumber = 0L;
        if (this.pageOffset != -1L) {
            this.manager.getPageReader().unloadContent(this.pageOffset);
        }
        this.nextBand = 0;
        super.close();
    }

    public IContent execute() {
        if (this.executed) {
            return this.content;
        }
        this.context.setExecutingMasterPage(true);
        this.rs = this.context.getResultSets();
        this.context.setPageNumber(this.pageNumber);
        this.executed = true;
        try {
            IPageHint pageHint;
            Collection<PageVariable> vars;
            long pageNo = this.pageNumber;
            PageHintReader hintReader = this.manager.getPageHintReader();
            long totalPage = hintReader.getTotalPage();
            if (this.pageNumber > totalPage) {
                pageNo = totalPage;
            }
            if ((vars = (pageHint = hintReader.getPageHint(pageNo)).getPageVariables()) != null) {
                this.context.addPageVariables(vars);
            }
            this.pageOffset = hintReader.getPageOffset(pageNo, this.masterPage.getName());
            CachedReportContentReaderV3 pageReader = this.manager.getPageReader();
            this.content = pageReader.loadContent(this.pageOffset);
            InstanceID iid = this.content.getInstanceID();
            long id = iid.getComponentID();
            this.masterPage = (SimpleMasterPageDesign)this.context.getReport().getReportItemByID(id);
            this.content.setGenerateBy(this.masterPage);
            IPageContent pageContent = (IPageContent)this.content;
            pageContent.setPageNumber(this.pageNumber);
            return this.content;
        }
        catch (IOException ex) {
            this.context.addException(this.getDesign(), (BirtException)new EngineException(ex.getLocalizedMessage(), ex));
            return null;
        }
    }

    protected ReportItemExecutor doCreateExecutor(long offset) throws Exception {
        if (this.nextBand >= 0 && this.nextBand <= 2) {
            ArrayList band = null;
            switch (this.nextBand) {
                case 0: {
                    band = this.masterPage.getHeaders();
                    break;
                }
                case 2: {
                    band = this.masterPage.getFooters();
                    break;
                }
                case 1: {
                    band = new ArrayList();
                }
            }
            ++this.nextBand;
            PageBandExecutor bandExecutor = new PageBandExecutor(this, band);
            bandExecutor.setParent(this);
            bandExecutor.setOffset(offset);
            return bandExecutor;
        }
        return null;
    }

    protected void doSkipToExecutor(InstanceID id, long offset) throws Exception {
        throw new IllegalStateException("master page never comes with page hints");
    }
}

