/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.IBasePreparedQuery;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBaseQueryResults;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.ISubqueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.olap.api.ICubeQueryResults;
import org.eclipse.birt.data.engine.olap.api.IPreparedCubeQuery;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ISubCubeQueryDefinition;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.engine.api.DataID;
import org.eclipse.birt.report.engine.api.DataSetID;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.api.impl.QueryTask;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.engine.data.IDataEngine;
import org.eclipse.birt.report.engine.data.dte.AbstractDataEngine;
import org.eclipse.birt.report.engine.data.dte.CubeResultSet;
import org.eclipse.birt.report.engine.data.dte.QueryResultSet;
import org.eclipse.birt.report.engine.executor.EngineExtensionManager;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.extension.ICubeResultSet;
import org.eclipse.birt.report.engine.extension.IQueryResultSet;
import org.eclipse.birt.report.engine.extension.engine.IDataExtension;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.model.api.ReportItemHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryUtil {
    public static List<IBaseResultSet> getResultSet(ReportContent report, InstanceID instanceID) {
        Report design = report.getDesign();
        ExecutionContext context = report.getExecutionContext();
        try {
            ArrayList<QueryTask> plan = QueryUtil.createPlan(design, instanceID);
            return QueryUtil.executePlan(context, plan);
        }
        catch (EngineException ex) {
            context.addException(ex);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getResultSetId(ReportContent report, InstanceID instanceID) {
        Report design = report.getDesign();
        ArrayList<QueryTask> plan = QueryUtil.createPlan(design, instanceID);
        if (plan == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        ExecutionContext executionContext = report.getExecutionContext();
        try {
            int current = plan.size() - 1;
            while (true) {
                if (current < 0) {
                    return sb.toString();
                }
                QueryTask task = plan.get(current);
                IDataQueryDefinition query = task.getQuery();
                if (task.getParent() == null) {
                    String rset = QueryUtil.getResultSetID(executionContext, null, "-1", query);
                    if (rset == null) {
                        return null;
                    }
                    sb.append(rset);
                } else {
                    if (sb.length() == 0) {
                        throw new EngineException("Error.InvalidInstanceIDError", instanceID);
                    }
                    long rowid = task.getRowID();
                    if (query instanceof ISubqueryDefinition) {
                        String queryName = query.getName();
                        sb.insert(0, "{");
                        sb.append("}.").append(rowid).append(".").append(queryName);
                    } else {
                        String id = task.getCellID();
                        if (id == null) {
                            id = String.valueOf(rowid);
                        }
                        String rset = QueryUtil.getResultSetID(executionContext, sb.toString(), id, query);
                        sb.setLength(0);
                        if (rset != null) {
                            sb.append(rset);
                        }
                    }
                }
                --current;
            }
        }
        catch (EngineException ex) {
            executionContext.addException(ex);
        }
        return sb.toString();
    }

    /*
     * Unable to fully structure code
     */
    public static ArrayList<QueryTask> createTablePlan(Report report, InstanceID instanceId) throws EngineException {
        iid = instanceId;
        query = null;
        while (iid != null) {
            id = iid.getComponentID();
            design = (ReportItemDesign)report.getReportItemByID(id);
            dataQuery = design.getQuery();
            if (dataQuery != null) {
                handle = (ReportItemHandle)design.getHandle();
                if (!handle.allowExport()) {
                    throw new EngineException("Error.ResultsetExtractError");
                }
                if (!(dataQuery instanceof IBaseQueryDefinition)) {
                    return null;
                }
                query = (IBaseQueryDefinition)dataQuery;
                break;
            }
            iid = iid.getParentID();
        }
        dsIDs = new ArrayList<DataSetID>();
        plan = new ArrayList<QueryTask>();
        ** GOTO lbl42
        {
            block7: {
                if (iid.getDataID() == null) break block7;
                dataId = iid.getDataID();
                dsId = dataId.getDataSetID();
                found = false;
                itr = dsIDs.iterator();
                while (itr.hasNext()) {
                    if (!((DataSetID)itr.next()).equals(dsId)) continue;
                    found = true;
                    break;
                }
                if (found) break block7;
                dsIDs.add(dsId);
                task = dataId.getCellID() != null ? new QueryTask((IDataQueryDefinition)query, dsId, dataId.getCellID(), iid) : new QueryTask((IDataQueryDefinition)query, dsId, (int)dataId.getRowID(), iid);
                plan.add(task);
                ** GOTO lbl40
            }
            iid = iid.getParentID();
            do {
                if (iid != null) continue block1;
lbl40:
                // 2 sources

                if (iid == null) break block1;
                query = query.getParentQuery();
lbl42:
                // 2 sources

            } while (query != null);
        }
        task = new QueryTask((IDataQueryDefinition)query, null, -1, null);
        plan.add(task);
        return plan;
    }

    public static ArrayList<QueryTask> createPlan(Report report, InstanceID instanceId) {
        ArrayList<IDataQueryDefinition> queries = new ArrayList<IDataQueryDefinition>();
        InstanceID iid = instanceId;
        InstanceID dsIID = null;
        while (iid != null) {
            IDataQueryDefinition query;
            long id = iid.getComponentID();
            ReportItemDesign design = (ReportItemDesign)report.getReportItemByID(id);
            if (design != null && (query = design.getQuery()) != null) {
                queries.add(query);
                if (dsIID == null) {
                    dsIID = iid.getParentID();
                }
            }
            iid = iid.getParentID();
        }
        if (queries.size() == 0) {
            return null;
        }
        ArrayList<DataSetID> datasets = new ArrayList<DataSetID>();
        ArrayList<QueryTask> plan = new ArrayList<QueryTask>();
        for (IDataQueryDefinition query : queries) {
            while (dsIID != null) {
                DataID dataId;
                DataSetID dsId;
                if (dsIID.getDataID() != null && !datasets.contains(dsId = (dataId = dsIID.getDataID()).getDataSetID())) {
                    datasets.add(dsId);
                    QueryTask task = null;
                    task = dataId.getCellID() != null ? new QueryTask(query, dsId, dataId.getCellID(), dsIID) : new QueryTask(query, dsId, (int)dataId.getRowID(), dsIID);
                    plan.add(task);
                    break;
                }
                dsIID = dsIID.getParentID();
            }
            if (dsIID == null) break;
        }
        QueryTask task = new QueryTask((IDataQueryDefinition)queries.get(queries.size() - 1), null, -1, null);
        plan.add(task);
        return plan;
    }

    public static List executePlan(final ExecutionContext executionContext, ArrayList<QueryTask> plan) throws EngineException {
        ArrayList<IBaseResultSet> results = new ArrayList<IBaseResultSet>();
        IBaseResultSet parent = QueryUtil.executePlan(plan, 0, executionContext, new IResultSetIDProvider(){

            public String getResultsID(String parent, String rawId, IDataQueryDefinition query) {
                return QueryUtil.getResultSetID(executionContext, parent, rawId, query);
            }
        });
        if (parent != null && !results.contains(parent)) {
            results.add(parent);
        }
        return results;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IBaseResultSet executePlan(List<QueryTask> plan, int index, ExecutionContext executionContext, IResultSetIDProvider resultsIDProvider) throws EngineException {
        if (plan == null) return null;
        if (plan.size() == 0) {
            return null;
        }
        IBaseResultSet parent = null;
        try {
            int current = plan.size() - 1;
            while (true) {
                if (current < index) {
                    return parent;
                }
                QueryTask task = plan.get(current);
                IDataQueryDefinition query = task.getQuery();
                if (task.getParent() == null) {
                    String rsID = resultsIDProvider.getResultsID(null, "-1", query);
                    IBaseQueryResults baseResults = QueryUtil.executeQuery(null, query, rsID, executionContext);
                    if (baseResults == null) {
                        return null;
                    }
                    if (baseResults instanceof IQueryResults) {
                        parent = new QueryResultSet(executionContext.getDataEngine(), executionContext, (IQueryDefinition)query, (IQueryResults)baseResults);
                    } else {
                        if (!(baseResults instanceof ICubeQueryResults)) return null;
                        parent = new CubeResultSet(executionContext.getDataEngine(), executionContext, (ICubeQueryDefinition)query, (ICubeQueryResults)baseResults);
                    }
                } else {
                    IResultIterator parentItr;
                    assert (parent != null);
                    String parentID = null;
                    if (parent instanceof IQueryResultSet) {
                        parentItr = ((IQueryResultSet)parent).getResultIterator();
                        parentItr.moveTo(task.getRowID());
                        parentID = ((QueryResultSet)parent).getQueryResultsID();
                    } else if (parent instanceof ICubeResultSet) {
                        ((ICubeResultSet)parent).skipTo(task.getCellID());
                        parentID = ((CubeResultSet)parent).getQueryResultsID();
                    }
                    if (query instanceof ISubqueryDefinition) {
                        parentItr = ((QueryResultSet)parent).getResultIterator();
                        String queryName = query.getName();
                        ScriptContext scriptContext = executionContext.getScriptContext();
                        IResultIterator itr = parentItr.getSecondaryIterator(scriptContext, queryName);
                        parent = new QueryResultSet((QueryResultSet)parent, (ISubqueryDefinition)query, itr);
                    } else {
                        String rsID = resultsIDProvider.getResultsID(parentID, parent.getRawID(), query);
                        IBaseQueryResults baseResults = QueryUtil.executeQuery(parent.getQueryResults(), query, rsID, executionContext);
                        if (baseResults instanceof IQueryResults) {
                            parent = new QueryResultSet(executionContext.getDataEngine(), executionContext, parent, (IQueryDefinition)query, (IQueryResults)baseResults);
                        } else {
                            if (!(baseResults instanceof ICubeQueryResults)) return null;
                            if (query instanceof ICubeQueryDefinition) {
                                parent = new CubeResultSet(executionContext.getDataEngine(), executionContext, parent, (ICubeQueryDefinition)query, (ICubeQueryResults)baseResults);
                            } else if (query instanceof ISubCubeQueryDefinition) {
                                parent = new CubeResultSet(executionContext.getDataEngine(), executionContext, parent, (ISubCubeQueryDefinition)query, (ICubeQueryResults)baseResults);
                            }
                        }
                    }
                }
                --current;
            }
        }
        catch (EngineException ex) {
            throw ex;
        }
        catch (BirtException ex) {
            throw new EngineException(ex);
        }
    }

    private static String getResultSetID(ExecutionContext context, String parent, String rowId, IDataQueryDefinition query) {
        IDataEngine engine = null;
        try {
            engine = context.getDataEngine();
        }
        catch (EngineException e) {
            context.addException(e);
        }
        if (engine != null && engine instanceof AbstractDataEngine) {
            AbstractDataEngine dataEngine = (AbstractDataEngine)engine;
            String queryId = dataEngine.getQueryID(query);
            String result = dataEngine.getResultID(parent, rowId, queryId);
            if (result == null) {
                result = dataEngine.getResultIDByRowID(parent, rowId, queryId);
            }
            return result;
        }
        return null;
    }

    public static void processQueryExtensions(IDataQueryDefinition query, ExecutionContext executionContext) throws EngineException {
        String[] extensions = executionContext.getEngineExtensions();
        if (extensions != null) {
            EngineExtensionManager manager = executionContext.getEngineExtensionManager();
            String[] stringArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                String extensionName = stringArray[n2];
                IDataExtension extension = manager.getDataExtension(extensionName);
                if (extension != null) {
                    extension.prepareQuery(query);
                }
                ++n2;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IBaseQueryResults executeQuery(IBaseQueryResults parent, IDataQueryDefinition query, String rset, ExecutionContext executionContext) throws EngineException {
        try {
            DataRequestSession dataSession = executionContext.getDataEngine().getDTESession();
            if (dataSession == null) {
                return null;
            }
            Map appContext = executionContext.getAppContext();
            dataSession.getDataSessionContext().setAppContext(appContext);
            ScriptContext scriptContext = executionContext.getScriptContext();
            if (query instanceof QueryDefinition) {
                QueryDefinition tmpQuery = (QueryDefinition)query;
                tmpQuery.setQueryResultsID(rset);
                QueryUtil.processQueryExtensions(query, executionContext);
                IPreparedQuery pQuery = dataSession.prepare((IQueryDefinition)tmpQuery);
                if (pQuery != null) return dataSession.execute((IBasePreparedQuery)pQuery, parent, scriptContext);
                return null;
            }
            if (query instanceof ICubeQueryDefinition) {
                ICubeQueryDefinition cubeQuery = (ICubeQueryDefinition)query;
                cubeQuery.setQueryResultsID(rset);
                QueryUtil.processQueryExtensions(query, executionContext);
                IPreparedCubeQuery pQuery = dataSession.prepare(cubeQuery);
                if (pQuery != null) return dataSession.execute((IBasePreparedQuery)pQuery, parent, scriptContext);
                return null;
            }
            if (!(query instanceof ISubCubeQueryDefinition)) return null;
            ISubCubeQueryDefinition cubeQuery = (ISubCubeQueryDefinition)query;
            IPreparedCubeQuery pQuery = dataSession.prepare(cubeQuery);
            if (pQuery != null) return dataSession.execute((IBasePreparedQuery)pQuery, parent, scriptContext);
            return null;
        }
        catch (BirtException ex) {
            throw new EngineException(ex);
        }
    }

    public static interface IResultSetIDProvider {
        public String getResultsID(String var1, String var2, IDataQueryDefinition var3);
    }
}

