/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.writer;

import java.io.UnsupportedEncodingException;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.writer.ModuleWriter;

public class DesignWriter
extends ModuleWriter {
    private ReportDesign design;

    public DesignWriter(ReportDesign design) {
        this.design = design;
    }

    public void visitReportDesign(ReportDesign obj) {
        block6: {
            this.writer.startElement("report");
            super.visitReportDesign(obj);
            this.property(obj, "refreshRate");
            this.property(obj, "initialize");
            this.property(obj, "beforeFactory");
            this.property(obj, "afterFactory");
            this.property(obj, "beforeRender");
            this.property(obj, "afterRender");
            if (this.markLineNumber) {
                this.getModule().addLineNo(obj.getPropertyDefn("theme"), new Integer(this.writer.getLineCounter()));
            }
            this.property(obj, "theme");
            this.resourceKey(obj, "displayNameID", "displayName");
            this.property(obj, "iconFile");
            this.property(obj, "cheatSheet");
            this.property(obj, "eventHandlerClass");
            this.property(obj, "layoutPreference");
            this.property(obj, "bidiLayoutOrientation");
            this.property(obj, "enableACL");
            this.property(obj, "ACLExpression");
            this.property(obj, "cascadeACL");
            this.writeStructureList(obj, "libraries");
            this.writeStructureList(obj, "cssStyleSheets");
            this.writeSimpleStructureList(obj, "includeScripts", "fileName");
            this.writeStructureList(obj, "configVars");
            this.writeContents(obj, 8, "template-parameter-definitions");
            this.writeContents(obj, 1, "parameters");
            this.writeContents(obj, 2, "data-sources");
            this.writeContents(obj, 3, "data-sets");
            this.writeContents(obj, 9, "cubes");
            this.writeCustomColors(obj);
            this.writeTranslations(obj);
            this.writeContents(obj, 0, "styles");
            this.writeArrangedContents(obj, 5, "components");
            this.writeContents(obj, 4, "page-setup");
            this.writeContents(obj, 6, "body");
            this.writeContents(obj, 7, "scratch-pad");
            try {
                byte[] thumbnail = this.design.getThumbnail();
                if (thumbnail != null) {
                    byte[] data = base.encode(this.design.getThumbnail());
                    String value = new String(data, "8859_1");
                    if (value.length() < 80) {
                        this.writeEntry("property", "thumbnail", null, value, false);
                    } else {
                        this.writeLongIndentText("property", "thumbnail", value);
                    }
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
        this.writeEmbeddedImages(obj);
        this.writer.endElement();
    }

    protected Module getModule() {
        return this.design;
    }
}

